<?php
require_once 'config/connect.php';
require_once __DIR__ . '/vendor/autoload.php';

use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;

$mail = new PHPMailer(true);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$response = array(
    'success' => false,
    'message' => 'An error occurred. Please try again later.',
);

if (isset($_POST['regfsmt']) && $_POST['regfsmt'] == 'frmscnt') {

    $dateTimeNow = date('Y-m-d H:i:s');
    $data = array();

    $data['email'] = ($_POST['newsletter_email']) ? MRES_FILTER($_POST['newsletter_email']) : "";

    $insertedid = jRInsert("newsletter", $data);

    if ($insertedid > 0) {
        try {

            $response['success'] = true;
            $response['message'] = "Thank you for signing up.<br> You will now receive exciting updates to your email!";
        } catch (Exception $e) {
            // Log error and set error response
            error_log('Message could not be sent. Mailer Error: ' . $mail->ErrorInfo);
        }
    }
}

// Return response as JSON
header('Content-Type: application/json');
echo json_encode($response);
