 
<?php $__env->startSection('style1'); ?>
<style>

.addon-select option[value=""] {
    color: #999;
    font-style: italic;
}
#copyShirtBaseBtn {
    height: 38px;              /* SAME AS INPUTS */
    padding: 0 12px;           /* REMOVE EXTRA VERTICAL SPACE */
    line-height: 38px;         /* CENTER TEXT VERTICALLY */
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 13px;
    font-weight: 600;
    border-radius: 6px;        /* SAME AS INPUT */
}
/* FIX COLUMN ALIGNMENT */
.mobile-copy-btn {
    display: flex;
    align-items: flex-end;     /* PUSH BUTTON DOWN */
}
 .measure-input {
    height: 38px;
    font-size: 13px;
    text-align: center;
    border-radius: 6px;
    padding: 4px;
}
.measure-input::placeholder {
    font-size: 13px;        /* ⬅ slightly bigger */
    font-weight: 500;      /* ⬅ darker/thicker */
    color: #333;           /* ⬅ dark grey (near black) */
    opacity: 1;            /* ⬅ force full visibility */
}
.suggestion-box {
    position: absolute;
    top: 100%;
    left: 0;
    background: #fff;
    border: 1px solid #ccc;
    border-radius: 6px;
    max-height: 160px;
    overflow-y: auto;
    z-index: 99999;
    width: 100%;
}

.suggestion-item {
    padding: 6px 8px;
    cursor: pointer;
    font-size: 13px;
}

.suggestion-item:hover {
    background: #f1f1f1;
}
/* 🔽 SELECT BOX – DIFFERENT DESIGN */
.measure-select {
    height: 38px;
    font-size: 13px;
    border-radius: 6px;
    padding: 4px 8px;
    background-color: #f8f9fa;   /* light grey */
    border: 1px solid #999;
    font-weight: 600;
    text-align: center;
    cursor: pointer;
}

/* Arrow styling (modern look) */
.measure-select {
    appearance: none;
    background-image: url("data:image/svg+xml,%3Csvg fill='none' stroke='%23333' stroke-width='2' viewBox='0 0 24 24' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M6 9l6 6 6-6'%3E%3C/path%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 14px;
}

/* Placeholder option style */
.measure-select option[value=""] {
    color: #666;
}
tfoot td {
    border-top: 2px solid #000;
    background: #f8f9fa;
    font-size: 13px;
}
.measure-error {
    border: 2px solid #dc3545 !important;
    background-color: #fff0f0;
}

.measure-error::placeholder {
    color: #dc3545;
    font-weight: 600;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentarea'); ?>
<div class="container">

<h4>Create Order</h4>



 <div class="row mb-3 align-items-end position-relative">

    <!-- Customer Search -->
    <div class="col-md-4">
        <label class="fw-semibold">Customer Name</label>
        <input type="text"
               class="form-control"
               id="customerSearch"
               placeholder="Type customer name"
               autocomplete="off"
               autocorrect="off"
               autocapitalize="off"
               spellcheck="false">

        <div id="customerResults"
             class="list-group position-absolute w-40 d-none"
             style="z-index:1000"></div>

        <input type="hidden" id="selectedCustomerId">
    </div>

    <!-- Add Customer -->
    <div class="col-md-3">
        <button type="button"
                class="btn btn-outline-primary w-100"
                id="openAddCustomerBtn">
            + Add New Customer
        </button>
    </div>

    <!-- Add Garment -->
    <div class="col-md-3">
        <button type="button"
                class="btn btn-primary w-100"
                id="addCustomerOrder">
            + Add Garment
        </button>
    </div>

</div>




<div id="garmentWrapper" class="d-none border p-3 mb-3">

    <h6>Garment</h6>

    <div class="row">
       <div class="col-md-3">
    <label>Profile Name</label>
    <div class="input-group">
        <select class="form-control" id="profileSelect">
            <option value="">Select Profile</option>
        </select>
        <button type="button"
                class="btn btn-outline-primary"
                id="openAddProfileBtn">
            +
        </button>
    </div>
</div>

<div class="col-md-3">
            <label>Garment Type</label>
       <select class="form-control garment-type" required>
    <option value="">Select Garment</option>
    <option value="Shirt">Shirt</option>
    <option value="Pant">Pant</option>
    <option value="Blouse">Blouse</option>
    <option value="Chudithar">Chudithar</option>
</select>
        </div>
       <div class="col-md-2">
    <label class="fw-semibold">Age Type</label>

    <select name="age_type"
            class="form-select age-type">
        <option value="">Select Age Type</option>
        <option value="below_5">Below 5 Years</option>
        <option value="5_to_16">5 to 16 Years</option>
        <option value="adult">Adult</option>
    </select>
</div>
<div class="col-md-2 mt-2">
    <button type="button"
            class="btn btn-sm btn-warning w-100"
            id="cloneOrderBtn"
            disabled>
        🔁 Clone Measurements
    </button>
</div>

            <div class="blouse-image mb-3 d-none">
        <img src="<?php echo e(asset('images/blouse-measurement.png')); ?>"
             class="img-fluid border rounded"
             alt="Blouse Measurement Guide">
    </div>

    </div>

    <div class="row mt-3 measurement-area"></div>
</div>

<div class="mb-4">
<table class="table table-bordered table-sm">
    <thead class="table-dark">
        <tr>
            <th>#</th>
            <th>Profile</th>
            <th>Garment</th>
            <th>Base Price ₹</th>
            <th>Qty</th>
            <th>Add-Ons ₹</th>
            <th>Total ₹</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody id="savedCustomers">
        <tr id="noDataRow">
            <td colspan="8" class="text-center text-muted">
                No garment added yet
            </td>
        </tr>
    </tbody>
   

</table>

</div>

<form onsubmit="return false;">
<?php echo csrf_field(); ?>






 <div class="card mt-3">
    <div class="card-header bg-light">
        <strong>Payment & Delivery</strong>
    </div>

    <div class="card-body">
        <div class="row align-items-end">

            <!-- ✅ Total Clothes -->
           <div class="col-md-3 mb-2">
            <label>Discount ₹</label>
            <input type="number"
                class="form-control"
                id="orderDiscount"
                value="0"
                min="0">
        </div>


            <!-- ✅ Final Amount -->
            <div class="col-md-3 mb-2">
                <label>Total Order Amount</label>
                <input type="number"
                       class="form-control"
                       id="finalAmount"
                       readonly>
            </div>

            <!-- ✅ Advance Amount -->
            <div class="col-md-3 mb-2">
                <label>Advance Paid</label>
                <input type="number"
                       class="form-control"
                       id="advanceAmount"
                       placeholder="Advance Amount">
            </div>

            <!-- ✅ Balance -->
            <div class="col-md-3 mb-2">
                <label>Balance</label>
                <input type="number"
                       class="form-control"
                       id="balanceAmount"
                       readonly>
            </div>

            <!-- ✅ Delivery Date -->
            <div class="col-md-3 mb-2">
                <label>Delivery Date</label>
                <input type="date"
                       class="form-control"
                       id="deliveryDate"
                       required>
            </div>

            <!-- ✅ Submit Order -->
            <div class="col-md-3 mb-2">
                <button type="button"
                        class="form-control btn btn-success"
                        id="saveOrderBtn">
                    ✅ Submit Order
                </button>
            </div>

        </div>
    </div>
</div>


</form>
</div>

<div class="modal fade" id="confirmModal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Confirm Order Details</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body" id="confirmContent"></div>

      <div class="modal-footer">
        <button type="button" class="btn btn-secondary"
                data-bs-dismiss="modal">
            Cancel
        </button>
    <button type="button" class="btn btn-success" id="confirmSaveBtn">
    ✅ Submit Order
</button>
      </div>

    </div>
  </div>
</div>


<div class="modal fade" id="addCustomerModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Add New Customer</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <div class="mb-2">
            <label>Name</label>
            <input type="text" id="newCustomerName" class="form-control">
        </div>
        <div class="mb-2">
            <label>Phone</label>
            <input type="text" id="newCustomerPhone" class="form-control">
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">
            Cancel
        </button>
        <button class="btn btn-success" id="saveNewCustomer">
            Save Customer
        </button>
      </div>

    </div>
  </div>
</div>

<div class="modal fade" id="addProfileModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Add New Profile</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <div class="mb-2">
            <label>Name</label>
            <input type="text"
                   class="form-control"
                   id="newProfileName">
        </div>

        <div class="mb-2">
            <label>Relation</label>
            <select class="form-control" id="newProfileRelation">
                <option value="">Select</option>
                <option>Self</option>
                <option>Wife</option>
                <option>Husband</option>
                <option>Son</option>
                <option>Daughter</option>
                <option>Father</option>
                <option>Mother</option>
            </select>
        </div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary"
                data-bs-dismiss="modal">
            Cancel
        </button>
        <button class="btn btn-success"
                id="saveProfileBtn">
            Save
        </button>
      </div>

    </div>
  </div>
</div>



<div class="modal fade" id="cloneModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Clone Measurements</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <table class="table table-sm table-bordered">
          <thead>
            <tr>
              <th>Order No</th>
              <th>Garment</th>
              <th>Date</th>
              <th>Select</th>
            </tr>
          </thead>
          <tbody id="cloneOrderList">
            <tr>
              <td colspan="4" class="text-center text-muted">
                Loading...
              </td>
            </tr>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>


<div class="modal fade" id="editGarmentModal" tabindex="-1">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Edit Garment</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        
        <div id="editMeasurementWrapper"></div>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">
            Cancel
        </button>
        <button class="btn btn-success" id="updateGarmentBtn">
            ✅ Update
        </button>
      </div>

    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script1'); ?>

<script>
const customers = <?php echo json_encode($customers, 15, 512) ?>;
let orderItems = [];
let profiles = [];
let selectedGarment = null;
let selectedAge     = null;
let basePrice = 0;
let addonPrice = 0;
let editIndex = null;
let lastShirtBaseMeasurements = null;

function getEl(selector) {
    return document.querySelector(selector);
}
function setDefaultAgeType() {
    const adult = document.getElementById('ageAdult');
    if (adult) {
        adult.checked = true;
        selectedAge = 'Adult';
    }
}
function updateUnitPrice() {
    const unitInput = getEl('.garment-unit-price');
    if (!unitInput) return;

    unitInput.value = basePrice + addonPrice;
}
function calculateAddonTotal() {

    const addonSelect = document.querySelector('.addon-select');
    const addonTotalInput = document.querySelector('.addon-total');

    let addonTotal = 0;

    if (addonSelect) {
        Array.from(addonSelect.options).forEach(opt => {
            if (opt.selected) {
                addonTotal += Number(opt.dataset.price || 0);
            }
        });
    }

    // ✅ IMPORTANT SAFETY CHECK
    if (addonTotalInput) {
        addonTotalInput.value = addonTotal;
    }

    return addonTotal;
}

function calculateLineTotal() {

    const unitPriceInput = document.querySelector('.garment-unit-price');
    const qtyInput       = document.querySelector('.garment-qty');

    const totalInput     = document.querySelector('.garment-total');

    if (!unitPriceInput || !qtyInput || !totalInput) return;

    const unitPrice = Number(unitPriceInput.value || 0);
    const qty       = Number(qtyInput.value || 1);


    const addonTotal = calculateAddonTotal();

    const lineTotal = ((unitPrice + addonTotal) * qty);

    totalInput.value = Math.max(lineTotal, 0);
}

function updateFinalAmount() {

    let total = 0;

    orderItems.forEach(item => {
        total += Number(item.total_amount || 0);
    });

    const discount =
        Number(document.getElementById('orderDiscount')?.value || 0);

    const final = Math.max(total - discount, 0);

    document.getElementById('finalAmount').value = final;

    const advance =
        Number(document.getElementById('advanceAmount')?.value || 0);

    document.getElementById('balanceAmount').value =
        Math.max(final - advance, 0);
}
function renderOrderTable() {

    const tbody = document.getElementById('savedCustomers');
    tbody.innerHTML = '';

    let totalQty = 0;
    let totalAddon = 0;
    let grandTotal = 0;

    if (!orderItems.length) {
        tbody.innerHTML = `
            <tr>
                <td colspan="8" class="text-center text-muted">
                    No garment added yet
                </td>
            </tr>`;
        return;
    }

    orderItems.forEach((item, index) => {

        totalQty += Number(item.qty || 0);
        totalAddon += Number(item.addon_total || 0);
        grandTotal += Number(item.total_amount || 0);

        let addonHtml = '-';
        if (item.addons?.length) {
            addonHtml = item.addons
                .map(a => `${a.addon_name} (₹${a.addon_price})`)
                .join(', ');
        }
            let garmentLabel = item.garment_type;
        if (item.garment_type?.toLowerCase() === 'shirt') {
            const m = item.measurements || {};
            const type = (m.shirt_type || '').toLowerCase();

            if (type.includes('full')) {
                garmentLabel = 'Shirt (Full)';
            } else if (type.includes('half')) {
                garmentLabel = 'Shirt (Half)';
            }
        }

        tbody.insertAdjacentHTML('beforeend', `
            <tr>
                <td>${index + 1}</td>
                <td>${item.profile_name}</td>
                <td>${garmentLabel}</td>
                <td>₹ ${item.unit_price}</td>
                <td>${item.qty}</td>
                <td>${addonHtml}</td>
                <td>₹ ${item.total_amount}</td>
                <td>
                    <button class="btn btn-sm btn-warning editRowBtn" data-index="${index}">✏️</button>
                    <button class="btn btn-sm btn-danger deleteRowBtn" data-index="${index}">🗑</button>
                </td>
            </tr>
        `);
    });

    /* ================= BOTTOM SUMMARY ROW ================= */
    tbody.insertAdjacentHTML('beforeend', `
        <tr class="fw-bold border-top">
            <td></td>
            <td></td>
            <td></td>
            <td class="text-end">TOTAL</td>
            <td>${totalQty}</td>
            <td>₹ ${totalAddon}</td>
            <td>₹ ${grandTotal}</td>
            <td></td>
        </tr>
    `);

    updateFinalAmount();
}
function resetGarmentAfterAdd() {

    isEditing = false;   // 🔥 EXIT EDIT MODE
    editIndex = null;

    setTimeout(() => {   // 🔥 wait for all other JS to finish

        const garmentSelect = document.querySelector('.garment-type');
        garmentSelect.value = '';
        garmentSelect.selectedIndex = 0;

        garmentSelect.dispatchEvent(
            new Event('change', { bubbles: true })
        );

        document.querySelector('.measurement-area').innerHTML = '';
        document.querySelectorAll('.age-type').forEach(el => el.value = '');

        basePrice = 0;
        addonPrice = 0;

    }, 0);
}



function updateTotal() {
    const unitPrice = Number(getEl('.garment-unit-price')?.value || 0);
    const discount  = Number(getEl('.garment-discount')?.value || 0);
    const qty      = Number(getEl('.garment-qty')?.value || 1);


    let total = (unitPrice * qty) - discount;
    if (total < 0) total = 0;

    const totalInput = getEl('.garment-total');
    if (totalInput) totalInput.value = total;
}
function attachMeasurementSuggestions(input) {

    let box = null;

    input.addEventListener('focus', show);
    input.addEventListener('input', show);

    function show() {
        close();

        const wrapper = input.parentElement;
        wrapper.style.position = 'relative';

        box = document.createElement('div');
        box.className = 'suggestion-box';

        const query = input.value || '';

        measurementValues
            .filter(v => v.startsWith(query))
            .slice(0, 20)
            .forEach(val => {
                const item = document.createElement('div');
                item.className = 'suggestion-item';
                item.textContent = val;

                item.addEventListener('mousedown', () => {
                    input.value = val;
                    close();
                });

                box.appendChild(item);
            });

        if (box.children.length > 0) {
            wrapper.appendChild(box);
        }
    }

    function close() {
        if (box) {
            box.remove();
            box = null;
        }
    }

    document.addEventListener('click', e => {
        if (!input.contains(e.target)) close();
    });
}

 const CUSTOMER_PROFILE_ROUTE =
    "<?php echo e(route('admin.OrderManagement-customerProfiles', ['customer' => '__CID__'])); ?>";

function loadProfiles(customerId) {

    const url = CUSTOMER_PROFILE_ROUTE.replace('__CID__', customerId);
    const select = document.getElementById('profileSelect');

    // reset dropdown
    select.innerHTML = `<option value="">Select Profile</option>`;

    fetch(url)
        .then(res => res.json())
        .then(res => {

            const profiles = res.data || [];
            const selfProfileId = res.self_profile_id;

            profiles.forEach(p => {
                select.insertAdjacentHTML(
                    'beforeend',
                    `<option value="${p.id}">
                        ${p.profile_name}${p.relation === 'Self' ? ' (Self)' : ''}
                     </option>`
                );
            });

            // ✅ AUTO SELECT CUSTOMER NAME AS PROFILE
            if (selfProfileId) {
                select.value = String(selfProfileId);
            }
        });
}






function tryUpdatePrice() {

        const ageInput = document.querySelector('.age-type').value;
    const garment    = document.querySelector('.garment-type').value;
    if (!ageInput || !garment) return;
      selectedAge = ageInput.value;
    selectedGarment = garment.value;

    if (!selectedGarment || !selectedAge) return;

  fetch(`<?php echo e(route('admin.OrderManagement-price')); ?>?garment=${encodeURIComponent(selectedGarment)}&age=${encodeURIComponent(selectedAge)}`)

        .then(res => res.json())
        .then(res => {
            basePrice = Number(res.price || 0);
            updateUnitPrice();
            updateTotal();
        })
        .catch(() => {
            basePrice = 0;
            updateUnitPrice();
            updateTotal();
        });
}


    function generateFractionMeasurements(max = 100) {
        const fractions = ['', '¼', '½', '¾'];
        const values = [];

        for (let i = 1; i <= max; i++) {
            fractions.forEach(f => {
                values.push(`${i}${f}`);
            });
        }
        return values;
    }

    // ✅ GLOBAL measurement values
    const measurementValues = generateFractionMeasurements(100);

/* ================= HELPERS ================= */
function showError(msg, el = null) {
    alert(msg);
    if (el) el.focus();
}
function enableAutoFocusNextMeasurement() {

    const inputs = Array.from(
        document.querySelectorAll('.measurement-input')
    );

    inputs.forEach((input, index) => {

        input.addEventListener('keydown', e => {

            if (e.key === 'Enter') {
                e.preventDefault();

                const next = inputs[index + 1];
                if (next) {
                    next.focus();
                    next.select?.();
                }
            }
        });
    });
}


 function loadPreviousMeasurements() {

    const customerId = document.getElementById('selectedCustomerId')?.value;
    const profileId  = document.getElementById('profileSelect')?.value;
    const garment    = document.querySelector('.garment-type')?.value;

    // ✅ STOP if resetForm() already ran
    if (!customerId || !profileId || !garment) return;

    fetch(`<?php echo e(route('admin.OrderManagement-latestMeasurements')); ?>`
        + `?customer=${customerId}`
        + `&profile_id=${profileId}`
        + `&garment=${encodeURIComponent(garment)}`
    )
    .then(res => res.json())
    .then(res => {
        if (!res.data) return;


        const measurements = res.data;

        Object.entries(measurements).forEach(([key, value]) => {

            if (!value) return;

            /* ================= RADIO / BUTTON TYPE ================= */
            if (key === 'shirt_type') {
                applyRadioMeasurement(key, value);
                return;
            }

            /* ================= INPUT / SELECT ================= */
            const el = document.querySelector(
                `.measurement-input[data-key="${key}"]`
            );

            if (!el) return;

            el.value = value;
            el.classList.add('border-success');

            // 🔥 Important for SELECT
            if (el.tagName === 'SELECT') {
                el.dispatchEvent(new Event('change'));
            }
        });
       // 🔹 SPLIT POCKET VALUE INTO UP / DOWN INPUTS
if (measurements.pocket && measurements.pocket.includes('/')) {

    const [up, down] = measurements.pocket.split('/');

    const upInput = document.querySelector('[data-key="pocket_up"]');
    const downInput = document.querySelector('[data-key="pocket_down"]');

    if (upInput && up) {
        upInput.value = up;
        upInput.classList.add('border-success');
    }

    if (downInput && down) {
        downInput.value = down;
        downInput.classList.add('border-success');
    }
}



    })
    .catch(err => {
        console.error('Measurement load failed', err);
    });
}



/* ================= CUSTOMER SEARCH ================= */



/* ================= CUSTOMER SEARCH ================= */
const searchInput = document.getElementById('customerSearch');
const resultsBox = document.getElementById('customerResults');

const garmentWrapper = document.getElementById('garmentWrapper');
const deliveryDate = document.getElementById('deliveryDate');

/* ================= CUSTOMER SEARCH ================= */
searchInput.addEventListener('input', function () {

    resultsBox.innerHTML = '';

    if (!this.value) {
        resultsBox.classList.add('d-none');
        return;
    }

    customers
        .filter(c => c.name.toLowerCase().includes(this.value.toLowerCase()))
        .forEach(c => {
            const item = document.createElement('a');
            item.className = 'list-group-item list-group-item-action';
            item.textContent = `${c.name} (${c.phone})`;

            item.onclick = () => {
                searchInput.value = `${c.name} (${c.phone})`;
                document.getElementById('selectedCustomerId').value = c.id;
                profileSelect.value = c.name;
                loadProfiles(c.id);
                // garmentWrapper.classList.remove('d-none');
                resultsBox.classList.add('d-none');
            };

            resultsBox.appendChild(item);
        });

    resultsBox.classList.remove('d-none');
});

 const shirtFields = [
{
    type: 'radio',
    k: 'shirt_type',
    options: ['Half / அரை கை', 'Full / முழு கை']
  },

 { k: "height",        p: "உயரம்" },
  { k: "body",          p: "உடல்" },

  // ⬇️ sleeve fields will be injected here dynamically

  { k: "thol_pattai",   p: "தோள் பட்டை" },
  { k: "kai_height",     p: "கை உயரம்" },

  { k: "side_loose_1",  p: "பக்கம் லூஸ் - 1" },
  { k: "side_loose_2",  p: "பக்கம் லூஸ் - 2" },
  { k: "side_loose_3",  p: "பக்கம் லூஸ் - 3" },

  { k: "collar",        p: "காலர்" },
   
  {
    type: "select",
    k: "front_9",
    p: "முன் - 9",
    options: ["9", "8", "7", "Hidden"]
  },
  {
    type: "select",
    k: "model",
    p: "மாடல்",
    options: ["Normal", "Slim", "Designer"]
  },
 {
  type: "split",
  k: "pocket",
  p: "பாக்கெட்"
}
];
const halfSleeveFields = [
  { k: "half_kai_uyaram",   p: "அரை கை உயரம்" },
  { k: "half_kai_munda",   p: "அரை கை முன்டா" },
  { k: "half_kai_munaikai",p: "அரை கை முனைக்கை" }
];

const fullSleeveFields = [
  { k: "full_kai_uyaram",   p: "முழு கை உயரம்" },
  { k: "full_kai_munaikai",p: "முழு கை முனைக்கை" },
  { k: "full_kai_munda",   p: "முழு கை முன்டா" },
  { k: "full_kai_kappu",   p: "முழு கை கப்பு" }
];
const HAND_KEYS = [
  'half_kai_uyaram',
  'half_kai_munda',
  'half_kai_munaikai',
  'full_kai_uyaram',
  'full_kai_munda',
  'full_kai_munaikai',
  'full_kai_kappu'
];
const pantFields = [

  { type:'input', k:'uyaram',        p:'Uyaram / Length / உயரம்' },

  { type:'input', k:'iduppu',        p:'Iduppu / Waist / இடுப்பு' },

  { type:'input', k:'hi_hip',        p:'Hi Hip / மேல் இடுப்பு' },

  { type:'input', k:'low_hip',       p:'Low Hip / கீழ் இடுப்பு' },

  { type:'input', k:'seat',          p:'Seat / சீட்' },

  { type:'input', k:'thodai',        p:'Thodai / Thigh / தொடை' },

  { type:'input', k:'mutti',         p:'Mutti / Knee / முட்டி' },

  { type:'input', k:'bottom',        p:'Bottom / கால்திறப்பு' },

  { type:'input', k:'zip_round',     p:'Zip Round / ஜிப் சுற்று' },

  { type:'input', k:'bottom_fit',    p:'Bottom Fit / கீழ் ஃபிட்' },

  { type:'input', k:'model',         p:'Model / மாடல்' },

  /* ===== TWO-VALUE INPUTS (value / value) ===== */

  { type:'split', k:'Adinkal Zip',   p:'அடிக்கால் ஜிப்' },

  { type:'split', k:'Cut Pocket',  p:'கட் பாக்கெட்' },

  { type:'split', k:'Ticket Pocket', p:'டிக்கெட் பாக்கெட்' }

];


const blouseFields = [
 {k:'blouse_back_length', l:'Blouse Back Length / பின்நீளம்'},
 {k:'full_shoulder', l:'Full Shoulder / முழு தோள்'},
 {k:'shoulder_strap', l:'Shoulder Strap / தோள் பட்டை'},
 {k:'back_neck_depth', l:'Back Neck Depth / பின் கழுத்து ஆழம்'},
 {k:'front_neck_depth', l:'Front Neck Depth / முன் கழுத்து ஆழம்'},
 {k:'shoulder_to_apex', l:'Shoulder to Apex / தோளிலிருந்து உச்சி'},
 {k:'front_length', l:'Front Length / முன் நீளம்'},
 {k:'chest_round', l:'Chest (Around) / மார்பு சுற்று'},
 {k:'waist_round', l:'Waist (Around) / இடுப்பு சுற்று'},
 {k:'sleeve_length', l:'Sleeve Length / கை நீளம்'},
 {k:'arm_round', l:'Arm Round / கை சுற்று'},
 {k:'sleeve_round', l:'Sleeve Round / கை முடிவு'},
 {k:'arm_hole', l:'Arm Hole / கை குழி'}
];

const chuditharTopFields = [
 {k:'top_length', l:'Full Length / முழு நீளம்'},
 {k:'shoulder', l:'Shoulder / தோள்'},
 {k:'bust_round', l:'Bust / Chest (Around) / மார்பு சுற்று'},
 {k:'waist_round', l:'Waist (Around) / இடுப்பு சுற்று'},
 {k:'hip_round', l:'Hips (Around) / இடுப்பு சுற்று'},
 {k:'sleeve_length', l:'Sleeve Length / கை நீளம்'},
 {k:'sleeve_round', l:'Sleeve Opening / கை முடிவு'},
 {k:'arm_hole', l:'Arm Hole / கை குழி'},
 {k:'neck_depth_front', l:'Neck Depth Front / முன் கழுத்து'},
 {k:'neck_depth_back', l:'Neck Depth Back / பின் கழுத்து'}
];
const chuditharBottomFields = [
 {k:'waist_round', l:'Waist / Lower Waist / இடுப்பு'},
 {k:'bottom_length', l:'Length / நீளம்'},
 {k:'thigh_round', l:'Thigh / தொடை'},
 {k:'knee_round', l:'Knee / முழங்கால்'},
 {k:'calf_round', l:'Calf / கால்வளை'},
 {k:'ankle_round', l:'Bottom Round / Ankle / கணுக்கால்'}
];
document.addEventListener('click', function (e) {

    if (e.target.id !== 'saveProfileBtn') return;

    const customerId = document.getElementById('selectedCustomerId')?.value;
    const name = document.getElementById('newProfileName')?.value.trim();
    const relation = document.getElementById('newProfileRelation')?.value;

    if (!customerId) {
        alert('Please select customer first');
        return;
    }

    if (!name || !relation) {
        alert('Please enter name and relation');
        return;
    }

    fetch("<?php echo e(route('admin.OrderManagement-profileStore')); ?>", {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document
                .querySelector('meta[name="csrf-token"]')
                .getAttribute('content')
        },
        body: JSON.stringify({
            customer_id: customerId,
            profile_name: name,
            relation: relation
        })
    })
    .then(res => res.json())
    .then(res => {

        if (!res.success) {
            alert(res.message || 'Profile save failed');
            return;
        }

        // ✅ ADD PROFILE TO SELECT BOX
        const profileSelect = document.getElementById('profileSelect');

        const opt = document.createElement('option');
        opt.value = res.data.id;
        opt.text  = `${res.data.profile_name} (${res.data.relation})`;
        opt.selected = true;

        profileSelect.appendChild(opt);

        // ✅ CLOSE MODAL
        bootstrap.Modal
            .getInstance(document.getElementById('addProfileModal'))
            .hide();
    })
    .catch(() => alert('Server error'));
});

 document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('garment-type')) return;

    const garmentType = e.target.value;
    selectedGarment = garmentType;
    const garmentBlock = e.target.closest('#garmentWrapper');
    const measurementArea = garmentBlock.querySelector('.measurement-area');
    const notes = document.querySelector('.garment-notes')?.value || '';
    const qty   = Number(document.querySelector('.garment-qty')?.value || 1);
    const total = Number(document.querySelector('.garment-total')?.value || 0);


    measurementArea.innerHTML = '';
    if (!garmentType) return;

    // ================= SHIRT =================
 if (garmentType === 'Shirt') {

selectedGarment = garmentType;
    shirtFields.forEach(field => {

        // 🔹 RADIO → buttons (Full / Half கை)
      if (field.type === 'radio') {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-4 col-4 mb-2 d-flex gap-2">
            ${field.options.map(opt => `
                <button type="button"
                        class="btn btn-outline-secondary measure-toggle"
                        onclick="setShirtType(this, '${field.k}', '${opt}')">
                    ${opt}
                </button>
            `).join('')}
            <input type="hidden"
                   class="measurement-input"
                   data-key="${field.k}">
        </div>
    `);
    return;
}

        // 🔹 SELECT (Front / Model)
   if (field.type === 'select') {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-2 col-4 mb-2">
            <select class="form-control measure-select measurement-input"
                    data-key="${field.k}">
                <option value="">${field.p}</option>
                ${field.options.map(o =>
                    `<option value="${o}">${o}</option>`
                ).join('')}
            </select>
        </div>
    `);
    return;
}

if (field.type === 'split') {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-3 col-6 mb-2">
            <div class="d-flex align-items-center gap-1">
                <input type="text"
                       class="form-control measure-input measurement-input"
                       placeholder="${field.p} மேல்"
                       value=""
                       data-key="${field.k}_up"
                       list="measurementList">

                <span class="fw-bold">/</span>

                <input type="text"
                       class="form-control measure-input measurement-input"
                       placeholder="${field.p} கீழ்"
                       value=""
                       data-key="${field.k}_down"
                       list="measurementList">
            </div>
        </div>
    `);
    return;
}



        // 🔹 INPUT (Height, Shoulder, Collar...)
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-md-2 col-4 mb-2">
                <input type="text"
                       class="form-control measure-input measurement-input"
                       data-key="${field.k}"
                       placeholder="${field.p}"
                       list="measurementList">
            </div>
        `);
    });

    // 🔹 Reference Images (unchanged)
measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-3 mt-0  d-flex gap-2">
        <div id="imageContainer">
            <div class="input-group mb-2">
                <input type="file"
                       class="form-control reference-image"
                       name="reference_images[]"
                       accept="image/*"
                       placeholder="Reference Image">
                <button type="button"
                        class="btn btn-outline-primary addImageBtn">+</button>
            </div>
        </div>
    </div>
`);

    // 🔹 Notes / Qty / Total (unchanged)
    measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">
        <div class="row">

            <div class="col-md-6 mb-2">
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Notes / குறிப்புகள்"></textarea>
            </div>
                <div class="col-md-4 mb-2">
                    <label class="fw-semibold">Add-On</label>
                  <select class="form-control addon-select" multiple>
    <option value="" disabled>
        -- Select Add-On (Optional) --
    </option>

    <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($addon->id); ?>"
                data-price="<?php echo e($addon->price); ?>">
            <?php echo e($addon->name); ?> (₹<?php echo e($addon->price); ?>)
        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
<small class="text-muted">Hold Ctrl (or Cmd) and click the selected option again to unselect</small>
                </div>

                <div class="col-md-2 mb-2">
                    <label class="fw-semibold">Add-On Price</label>
                    <input type="number"
                        class="form-control addon-price"
                        value="0"
                        readonly>
                </div>

             <div class="col-md-2 mb-2">
                <label>Unit Price</label>
                <input type="number" class="form-control garment-unit-price" readonly>
            </div>


            <div class="col-md-3 mb-2">
                <label class="fw-semibold">No of Clothes</label>
                <input type="number"
                       class="form-control garment-qty"
                       value="1"
                       min="1">
            </div>

           <div class="col-md-3 mb-2 mobile-copy-btn">
    <label class="fw-semibold invisible">Action</label>
    <button type="button"
            class="btn btn-success w-100 copy-btn-equal"
            id="copyShirtBaseBtn">
        Copy Body Measurements
    </button>
</div>

 <div class="col-md-3 mb-2">
    <label class="fw-semibold">Total Amount</label>
    <div class="input-group">
        <input type="number"
               class="form-control garment-total"
               placeholder="₹ Amount">
        <button type="button"
                class="btn btn-success addGarmentBtn"
                title="Add this profile">
            ➕
        </button>
    </div>
</div>


        </div>
    </div>
`);
measurementArea.querySelectorAll('.measurement-input').forEach(input => {
    attachMeasurementSuggestions(input);
});
enableAutoFocusNextMeasurement();
setTimeout(() => {
    tryUpdatePrice();
        loadPreviousMeasurements();
}, 0);
    return;
}
    // ================= PANT =================
if (garmentType === 'Pant') {
selectedGarment = garmentType;
    pantFields.forEach(field => {

        // 🔹 SELECT
        if (field.type === 'select') {
            measurementArea.insertAdjacentHTML('beforeend', `
                <div class="col-md-2 col-4 mb-2">
                    <select class="form-control measure-input measurement-input"
                            data-key="${field.k}">
                        <option value="">${field.p}</option>
                        ${field.options.map(o =>
                            `<option value="${o}">${o}</option>`
                        ).join('')}
                    </select>
                </div>
            `);
            return;
        }
        if (field.type === 'split') {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-3 col-6 mb-2">
            <div class="d-flex align-items-center gap-1">
                <input type="text"
                       class="form-control measure-input measurement-input"
                       placeholder="${field.p} மேல்"
                       value=""
                       data-key="${field.k}_up"
                       list="measurementList">

                <span class="fw-bold">/</span>

                <input type="text"
                       class="form-control measure-input measurement-input"
                       placeholder="${field.p} கீழ்"
                       value=""
                       data-key="${field.k}_down"
                       list="measurementList">
            </div>
        </div>
    `);
    return;
}

        // 🔹 INPUT
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-md-2 col-4 mb-2">
                <input type="text"
                       class="form-control measure-input measurement-input"
                       data-key="${field.k}"
                       placeholder="${field.p}"
                       list="measurementList">
            </div>
        `);
    });
    // 🔹 Reference Images (unchanged)
measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-3 mt-0  d-flex gap-2">
        <div id="imageContainer">
            <div class="input-group mb-2">
                <input type="file"
                       class="form-control reference-image"
                       name="reference_images[]"
                       accept="image/*"
                       placeholder="Reference Image">
                <button type="button"
                        class="btn btn-outline-primary addImageBtn">+</button>
            </div>
        </div>
    </div>
`);

    // 🔹 Notes / Qty / Total (unchanged)
    measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">
        <div class="row">

            <div class="col-md-6 mb-2">
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Notes / குறிப்புகள்"></textarea>
            </div>
                    <div class="col-md-4 mb-2">
                <label class="fw-semibold">Add-On</label>
                <select class="form-control addon-select" multiple>
                    <option value="" disabled>
                        -- Select Add-On (Optional) --
                    </option>

                    <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($addon->id); ?>"
                                data-price="<?php echo e($addon->price); ?>">
                            <?php echo e($addon->name); ?> (₹<?php echo e($addon->price); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <small class="text-muted">Hold Ctrl (or Cmd) and click the selected option again to unselect</small>
            </div>

            <div class="col-md-2 mb-2">
                <label class="fw-semibold">Add-On Price</label>
                <input type="number"
                    class="form-control addon-price"
                    value="0"
                    readonly>
            </div>
             <div class="col-md-2 mb-2">
                <label>Unit Price</label>
                <input type="number" class="form-control garment-unit-price" readonly>
            </div>


            <div class="col-md-3 mb-2">
                <label class="fw-semibold">No of Clothes</label>
                <input type="number"
                       class="form-control garment-qty"
                       value="1"
                       min="1">
            </div>


          <div class="col-md-3 mb-2">
    <label class="fw-semibold">Total Amount</label>
    <div class="input-group">
        <input type="number"
               class="form-control garment-total"
               placeholder="₹ Amount">
        <button type="button"
                class="btn btn-success addGarmentBtn"
                title="Add this profile">
            ➕
        </button>
    </div>
</div>


        </div>
    </div>
`);
measurementArea.querySelectorAll('.measurement-input').forEach(input => {
    attachMeasurementSuggestions(input);
});
enableAutoFocusNextMeasurement();
setTimeout(() => {
    tryUpdatePrice();
        loadPreviousMeasurements();
}, 0);
    return;
}


    // ================= BLOUSE =================

    if (garmentType === 'Blouse') {
        blouseFields.forEach(field => {
            measurementArea.insertAdjacentHTML('beforeend', `
                <div class="col-md-3 mb-2">
                    <label>${field.l}</label>
                     <div class="row g-1">
                    <div class="col-7">
                        <input type="text"
                               class="form-control measurement-input"
                               data-key="${field.k}"
                                 list="measurementList">
                    </div>
                    </div>
                     </div>
            `);
        });
         measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">
        <div class="row">

            <div class="col-md-6 mb-2">
                <label class="fw-semibold">Notes</label>
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Any special instructions"></textarea>
            </div>

            <div class="col-md-3 mb-2">
                <label class="fw-semibold">No of Clothes</label>
                <input type="number"
                       class="form-control garment-qty"
                       value="1"
                       min="1">
            </div>

            <div class="col-md-3 mb-2">
    <label class="fw-semibold">Total Amount</label>
    <div class="input-group">
        <input type="number"
               class="form-control garment-total"
               placeholder="₹ Amount">
        <button type="button"
                class="btn btn-success addGarmentBtn"
                title="Add this profile">
            ➕
        </button>
    </div>
</div>


        </div>
    </div>
`);

        return;
    }


    // ================= CHUDITHAR =================
    if (garmentType === 'Chudithar') {

        // ---- TOP (KAMEEZ) ----
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-12 mt-3">
                <h6 class="text-primary">Top (Kameez)</h6>
                <hr>
            </div>
        `);

       chuditharTopFields.forEach(field => {
    measurementArea.insertAdjacentHTML('beforeend', `
        <div class="col-md-4 mb-2">
            <label class="fw-semibold">${field.l}</label>
            <div class="row g-1">
                <div class="col-7">
                    <input type="text"
                           class="form-control measurement-input"
                           data-key="top_${field.k}"
                               list="measurementList">
                </div>

            </div>
        </div>
    `);
});

        // ---- BOTTOM (CHURIDAR PANT) ----
        measurementArea.insertAdjacentHTML('beforeend', `
            <div class="col-12 mt-4">
                <h6 class="text-success">Bottom (Churidar Pant)</h6>
                <hr>
            </div>
        `);

        chuditharBottomFields.forEach(field => {
            measurementArea.insertAdjacentHTML('beforeend', `
                <div class="col-md-3 mb-2">
                    <label>${field.l}</label>
                     <div class="row g-1">
                    <div class="col-7">
                      <input type="text"class="form-control measurement-input" data-key="${field.k}"
                        list="measurementList" placeholder="Type 1, 2, 3...">
                    </div>

                </div>

            `);
        });
         measurementArea.insertAdjacentHTML('beforeend', `
    <div class="col-12 mt-3 border-top pt-3">

        <div class="row"><div class="col-md-4 mb-2">
    <label class="fw-semibold">Add-On</label>
    <select class="form-control addon-select" multiple>
    <option value="" disabled>
        -- Select Add-On --
    </option>

    <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($addon->id); ?>"
                data-price="<?php echo e($addon->price); ?>">
            <?php echo e($addon->name); ?> (₹<?php echo e($addon->price); ?>)
        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>

<small class="text-muted">
    Hold Ctrl (or Cmd) and click the selected option again to unselect
</small>

</div>

            <div class="col-md-6 mb-2">
                <label class="fw-semibold">Notes</label>
                <textarea class="form-control garment-notes"
                          rows="2"
                          placeholder="Any special instructions"></textarea>
            </div>
            <div class="col-md-2 mb-2">
                <label>Unit Price</label>
                <input type="number" class="form-control garment-unit-price" readonly>
            </div>


            <div class="col-md-3 mb-2">
                <label class="fw-semibold">No of Clothes</label>
                <input type="number"
                       class="form-control garment-qty"
                       value="1"
                       min="1">
            </div>
s
           <div class="col-md-3 mb-2">
    <label class="fw-semibold">Total Amount</label>
    <div class="input-group">
        <input type="number"
               class="form-control garment-total"
               placeholder="₹ Amount">
        <button type="button"
                class="btn btn-success addGarmentBtn"
                title="Add this profile">
            ➕
        </button>
    </div>
</div>

        </div>
    </div>
`);
    }
});

function resetMeasurementsOnly() {
    profileSelect.value = '';

    document.querySelector('.garment-type').value = '';
    document.querySelector('.measurement-area').innerHTML = '';
}
document.addEventListener('click', function (e) {
    const IGNORE_KEYS = [
    'pocket',
    'pocket_top',
    'pocket_bottom'
];


    if (e.target.id !== 'copyShirtBaseBtn') return;

    if (!lastShirtBaseMeasurements) {
    alert('No previous shirt measurements found');
    return;
}

Object.entries(lastShirtBaseMeasurements).forEach(([key, value]) => {

    if (value === undefined || value === null || value === '') return;

    const input = document.querySelector(
        `.measurement-input[data-key="${key}"]`
    );

    if (input) {
        input.value = value;
        input.classList.add('border-info');
    }
});
});

/* ================= ADD CUSTOMER ORDER ================= */
 document.addEventListener('DOMContentLoaded', function () {

    const addBtn = document.getElementById('addCustomerOrder');

    if (!addBtn) {
        console.warn('addCustomerOrder button not found');
        return;
    }

   addBtn.onclick = () => {

    const customerId =
        document.getElementById('selectedCustomerId')?.value;

    if (!customerId) {
        alert('Please select customer first');
        return;
    }

    // show garment section
    garmentWrapper.classList.remove('d-none');

    // 🔥 FORCE PROFILE = SELF
    const profileSelect = document.getElementById('profileSelect');
    if (profileSelect && profileSelect.querySelector('option[value="self"]')) {
        profileSelect.value = 'self';
    }

    const orderDiscountInput =
        document.getElementById('orderDiscount');

    if (orderDiscountInput) {
        orderDiscountInput.addEventListener(
            'input',
            updateFinalAmount
        );
    }

    // advance amount already should call updateFinalAmount
    const advanceInput = document.getElementById('advanceAmount');
    if (advanceInput) {
        advanceInput.addEventListener('input', updateFinalAmount);
    }
    // reset measurements only
    document.querySelector('.measurement-area').innerHTML = '';

};
});
document.addEventListener('DOMContentLoaded', () => {
    setDefaultAgeType();
});
// document.addEventListener('DOMContentLoaded', function () {

//     const saveBtn = document.getElementById('saveGarmentBtn');

//     if (!saveBtn) {
//         console.warn('saveGarmentBtn not found');
//         return;
//     }

//     saveBtn.onclick = () => {
//         addMeasurementsForCurrentPerson();
//     };
// });
document.addEventListener('click', function (e) {

     if (!e.target.classList.contains('addGarmentBtn')) return;

    addMeasurementsForCurrentPerson();
    if (e.target && e.target.id === 'saveGarmentBtn') {
        addMeasurementsForCurrentPerson();
    }

});
document.getElementById('advanceAmount').addEventListener('input', () => {

    const finalAmount = Number(document.getElementById('finalAmount').value || 0);
    const advance     = Number(document.getElementById('advanceAmount').value || 0);

    document.getElementById('balanceAmount').value =
        Math.max(finalAmount - advance, 0);
});
/* ================= SAVE ORDER (POPUP) ================= */
document.getElementById('saveOrderBtn').onclick = () => {

    if (orderItems.length === 0) {
        alert('Please add at least one garment');
        return;
    }

    let html = '';

    orderItems.forEach((item, index) => {
        html += `
            <div class="border p-3 mb-3">
                <h6>${index + 1}. ${item.customer_name} – ${item.garment_type}</h6>

                <table class="table table-sm table-bordered">
                    <tbody>
        `;

        Object.keys(item.measurements).forEach(key => {
            html += `
                <tr>
            <td>${key.replace(/[_]/g, ' ').replace(/\b\w/g, c => c.toUpperCase())}</td>
            <td>${item.measurements[key]}</td>
                </tr>
            `;
        });

        html += `
                    </tbody>
                </table>
            </div>
        `;
    });

    document.getElementById('confirmContent').innerHTML = html;

    new bootstrap.Modal(
        document.getElementById('confirmModal')
    ).show();
};


/* ================= CONFIRM SAVE ================= */
document.getElementById('confirmSaveBtn').onclick = () => {

    const formData = new FormData();

    formData.append(
        'customer_id',
        document.getElementById('selectedCustomerId').value
    );

    formData.append(
        'advance_amount',
        document.getElementById('advanceAmount').value || 0
    );

    formData.append(
        'delivery_date',
        document.getElementById('deliveryDate').value
    );
    formData.append(
    'discount',
    document.getElementById('orderDiscount').value || 0
);


    orderItems.forEach((item, index) => {

        // ✅ REQUIRED BACKEND KEYS
        formData.append(`garments[${index}][profile_id]`, item.profile_id);
        formData.append(`garments[${index}][garment_type]`, item.garment_type);
        formData.append(`garments[${index}][unit_price]`, item.unit_price);
        formData.append(`garments[${index}][quantity]`, item.qty);
        formData.append(`garments[${index}][discount]`, item.discount || 0);
        formData.append(`garments[${index}][notes]`,item.notes || '');

        // ✅ MEASUREMENTS
        Object.entries(item.measurements).forEach(([key, val]) => {
            formData.append(
                `garments[${index}][measurement][${key}]`,
                val
            );
        });
          if (item.images && item.images.length) {
        item.images.forEach(file => {
            formData.append(`garments[${index}][images][]`,file);
        });
    }

        // ✅ ADDONS (ONLY ID REQUIRED)
        if (item.addons && item.addons.length) {
            item.addons.forEach((addon, aIndex) => {
                formData.append(`garments[${index}][addons][${aIndex}][addon_id]`,
                    addon.addon_id
                );
            });
        }
    });

    fetch("<?php echo e(route('admin.OrderManagement-store')); ?>", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": document
                .querySelector('meta[name="csrf-token"]')
                .getAttribute('content')
        },
        body: formData
    })
    .then(res => res.json())
    .then(res => {

        if (!res.success) {
            alert(res.message || 'Order save failed');
            return;
        }

        alert('Order saved successfully');
        resetForm();
        window.location.href = "<?php echo e(route('admin.OrderManagement-index')); ?>";

        bootstrap.Modal
            .getInstance(document.getElementById('confirmModal'))
            .hide();
    })
    .catch(err => {
        console.error(err);
        alert('Server error');
    });
};



function setShirtType(btn, key, value) {
    // set value to hidden input
    const hidden = btn.parentElement.querySelector(
        `input[data-key="${key}"]`
    );
    if (hidden) hidden.value = value;

    // UI active state
    btn.parentElement.querySelectorAll('button')
        .forEach(b => b.classList.remove('active'));

    btn.classList.add('active');

       // 🔥 ADD THIS (NEW)
    if (key === 'shirt_type') {
        renderSleeveFields(value);
    }
}
//=============shirt sleeve render===============
function renderSleeveFields(value) {

    const area = document.querySelector('.measurement-area');
    if (!area) return;

    // remove old sleeve fields
    area.querySelectorAll('.sleeve-dynamic').forEach(el => el.remove());

    const bodyInput = area.querySelector('[data-key="body"]');
    if (!bodyInput) return;

    let insertAfter = bodyInput.closest('.col-md-2, .col-4');

    let fields = [];
    if (value.includes('Half')) fields = halfSleeveFields;
    if (value.includes('Full')) fields = fullSleeveFields;

    fields.forEach(f => {
        insertAfter.insertAdjacentHTML('afterend', `
            <div class="col-md-3 col-6 mb-2 sleeve-dynamic">
                <input type="text"
                       class="form-control measure-input measurement-input w-100"
                       data-key="${f.k}"
                       placeholder="${f.p}"
                       list="measurementList">
            </div>
        `);
        insertAfter = insertAfter.nextElementSibling;
    });

    // helpers
    area.querySelectorAll('.measurement-input').forEach(i => {
        attachMeasurementSuggestions(i);
    });

    enableAutoFocusNextMeasurement();
}



/* ================= RESET ================= */
function resetForm() {

    // ================= RESET JS STATE =================
    orderItems = [];
    basePrice  = 0;
    addonPrice = 0;
    selectedAge = null;
    editIndex = null;

    // ================= RESET CUSTOMER =================
    const customerSearch = document.getElementById('customerSearch');
    const customerId     = document.getElementById('selectedCustomerId');

    if (customerSearch) customerSearch.value = '';
    if (customerId) customerId.value = '';

    // ================= RESET PROFILE =================
    const profileSelect = document.getElementById('profileSelect');
    if (profileSelect) {
        profileSelect.innerHTML = `<option value="">Select Profile</option>`;
    }

    // ================= RESET GARMENT UI =================
    const garmentWrapper = document.getElementById('garmentWrapper');
    if (garmentWrapper) garmentWrapper.classList.add('d-none');

    const measurementArea = document.querySelector('.measurement-area');
    if (measurementArea) measurementArea.innerHTML = '';

    document.querySelectorAll('.age-type').forEach(el => el.value = '');

    // ================= RESET TOTALS =================
    const totalClothes  = document.getElementById('totalClothes');
    const finalAmount   = document.getElementById('finalAmount');
    const advanceAmount = document.getElementById('advanceAmount');
    const balanceAmount = document.getElementById('balanceAmount');
    const deliveryDate  = document.getElementById('deliveryDate');

    if (totalClothes)  totalClothes.value = '';
    if (finalAmount)   finalAmount.value = '';
    if (advanceAmount) advanceAmount.value = '';
    if (balanceAmount) balanceAmount.value = '';
    if (deliveryDate)  deliveryDate.value = '';

    // ================= RESET TABLE =================
    const tableBody = document.getElementById('savedCustomers');
    if (tableBody) {
        tableBody.innerHTML = `
            <tr id="noDataRow">
                <td colspan="9" class="text-center text-muted">
                    No garment added yet
                </td>
            </tr>
        `;
    }
}

document.addEventListener('DOMContentLoaded', function () {

    const openProfileBtn = document.getElementById('openAddProfileBtn');

    if (!openProfileBtn) {
        console.warn('openAddProfileBtn not found');
        return;
    }
const addProfileModalEl = document.getElementById('addProfileModal');
const addProfileModal  = new bootstrap.Modal(addProfileModalEl);


// ✅ MOVE FOCUS OUT OF MODAL
setTimeout(() => {
    document.getElementById('profileSelect')?.focus();
}, 150);


  openProfileBtn.onclick = function () {

    const customerId = document.getElementById('selectedCustomerId')?.value;

    if (!customerId) {
        alert('Please select customer first');
        return;
    }

    // clear old values
    document.getElementById('newProfileName').value = '';
    document.getElementById('newProfileRelation').value = '';

    // ✅ SHOW MODAL (NOW VALID)
    addProfileModal.show();
};
});


document.addEventListener('DOMContentLoaded', function () {
   // ================= REQUIRED ELEMENTS =================
const customerSearch   = document.getElementById('customerSearch');

    const advanceAmount = document.getElementById('advanceAmount');
    const garmentWrapper = document.getElementById('garmentWrapper');
    const resultsBox     = document.getElementById('customerResults');
    const cloneModalEl = document.getElementById('cloneModal');
    const cloneBtn     = document.getElementById('cloneOrderBtn');
            // Fill datalist once
        const datalist = document.getElementById('measurementList');
         if (!cloneModalEl || !cloneBtn) {
        console.warn('Clone modal or button not found');
        return;
    }
 const cloneModal = new bootstrap.Modal(cloneModalEl);


    const addCustomerModal = new bootstrap.Modal(
        document.getElementById('addCustomerModal')
    );

  attachImageButtonListeners();
    // ================= OPEN ADD CUSTOMER MODAL =================
    const openBtn = document.getElementById('openAddCustomerBtn');

    openBtn.addEventListener('click', function () {

        document.getElementById('newCustomerName').value =
            customerSearch.value || '';

        document.getElementById('newCustomerPhone').value = '';

        addCustomerModal.show(); // ✅ NOW THIS WILL WORK
    });

    // customers array already defined from blade:

    customers.forEach(c => {
    if (!c.phone && c.mobile) {
        c.phone = c.mobile;
    }
});



    /* SAVE NEW CUSTOMER (AJAX) */
    document.getElementById('saveNewCustomer').onclick = () => {

        const name  = document.getElementById('newCustomerName').value.trim();
        const phone = document.getElementById('newCustomerPhone').value.trim();

        if (!name || !phone) {
            alert('Please enter name and phone');
            return;
        }

        fetch("<?php echo e(route('admin.CustomerManagement-ajaxStore')); ?>", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-CSRF-TOKEN": document
                    .querySelector('meta[name="csrf-token"]')
                    .getAttribute('content')
            },
            body: JSON.stringify({ name, phone })
        })
        .then(res => res.json())
        .then(res => {

            if (!res.success) {
                alert('Customer save failed');
                return;
            }

            // ✅ ADD TO AUTOCOMPLETE LIST
            customers.push(res.data);

            // ✅ AUTO SELECT CUSTOMER
            searchInput.value = `${res.data.name} (${res.data.phone})`;
            document.getElementById('selectedCustomerId').value = res.data.id;

            // 🔥 LOAD PROFILES → THIS ADDS "SELF"
             loadProfiles(res.data.id);

            // hide modal
            addCustomerModal.hide();
        })
      .catch(() => alert('Server error'));
    };
/* ================= ADD MORE IMAGES ================= */
function attachImageButtonListeners() {
    document.addEventListener('click', function (e) {

        // ➕ ADD IMAGE
        if (e.target.classList.contains('addImageBtn')) {

            const container = document.getElementById('imageContainer');
            if (!container) return;

            const div = document.createElement('div');
            div.className = 'input-group mb-2';

            div.innerHTML = `
                <input type="file"
                       class="form-control reference-image"
                       name="reference_images[]"
                       accept="image/*">

                <button type="button"
                        class="btn btn-outline-danger removeImageBtn">
                    ×
                </button>
            `;

            container.appendChild(div);
        }

        // ❌ REMOVE IMAGE
        if (e.target.classList.contains('removeImageBtn')) {
            e.target.closest('.input-group').remove();
        }
    });
}


 window.addMeasurementsForCurrentPerson = function () {

    const customerId   = document.getElementById('selectedCustomerId').value;
    const customerName = customerSearch.value;

const profileSelect = document.getElementById('profileSelect');

 if (!validateMeasurements()) {
        alert('Please fill all required measurements');
        return;
    }

if (!profileSelect) {
    alert('Profile selector missing');
    return;
}

const profileId = profileSelect.value;

if (profileId === '' || profileId === null) {
    alert('Please select profile');
    profileSelect.focus();
    return;
}



    const profileName =
        profileSelect.options[profileSelect.selectedIndex]?.text;

    const garmentType = document.querySelector('.garment-type')?.value;
    const garmentQty  = Number(document.querySelector('.garment-qty')?.value || 1);
    const deliveryDate = document.getElementById('deliveryDate')?.value;
    const ageType = document.querySelector('.age-type')?.value;
    const unitPrice = Number(document.querySelector('.garment-unit-price')?.value || 0);
    const discount  = Number(document.querySelector('.garment-discount')?.value || 0);
    const notes = document.querySelector('.garment-notes')?.value || '';


    if (!customerId || !profileName || !garmentType || !ageType) {
        alert('Please select customer, profile, garment & age');
        return;
    }

    /* ================= ADD-ONS (FIXED) ================= */
    const addonSelect = document.querySelector('.addon-select'); // ✅ ELEMENT
    let addonsData = [];
    let addonTotal = 0;

    if (addonSelect instanceof HTMLSelectElement) {
        [...addonSelect.selectedOptions].forEach(opt => {

            const price = Number(opt.dataset.price || 0);

            addonsData.push({
                addon_id: Number(opt.value),
                addon_name: opt.text.trim(),
                addon_price: price
            });

            addonTotal += price;
        });
    }

    /* ================= MEASUREMENTS ================= */
    let measurements = {};
    document.querySelectorAll('.measurement-input').forEach(input => {
        measurements[input.dataset.key] = input.value;
    });

    if (Object.values(measurements).every(v => !v)) {
        alert('Please enter measurements');
        return;
    }
if (garmentType === 'Shirt') {

    lastShirtBaseMeasurements = {};

    Object.entries(measurements).forEach(([key, value]) => {

        if (HAND_KEYS.includes(key)) return;
        if (key === 'shirt_type') return;

        lastShirtBaseMeasurements[key] = value;
    });
}


    /* ================= TOTAL CALCULATION ================= */
    const calculatedTotal =
        (unitPrice* garmentQty)+ addonTotal;

        let images = [];

        document.querySelectorAll('#imageContainer input.reference-image')
    .forEach(input => {
        if (input.files && input.files[0]) {
            images.push(input.files[0]);
        }
    });
     const pocketUp =
    document.querySelector('[data-key="pocket_up"]')?.value || '';
const pocketDown =
    document.querySelector('[data-key="pocket_down"]')?.value || '';

if (pocketUp || pocketDown) {
    measurements.pocket = `${pocketUp}/${pocketDown}`;
}

    /* ================= BUILD ITEM ================= */
    const newItem = {
        customer_id: customerId,
        customer_name: customerName,

        profile_id: profileId,
        profile_name: profileName,

        garment_type: garmentType,
        age_type: ageType,

        unit_price: unitPrice,
        qty: garmentQty,


        notes: notes,
        images: images,

        addons: addonsData,
        addon_total: addonTotal,

        total_amount: Math.max(calculatedTotal, 0),
        delivery_date: deliveryDate,

        measurements
    };

    /* ================= ADD / EDIT ================= */
    if (editIndex !== null) {
        orderItems[editIndex] = newItem;
        editIndex = null;
    } else {
        orderItems.push(newItem);
    }

    renderOrderTable(); // ✅ MUST exist
    resetGarmentInputs();
    // ✅ CLOSE MEASUREMENT AREA
    garmentWrapper.classList.add('d-none');
};

document.addEventListener('click', function (e) {

    if (!e.target.classList.contains('deleteRowBtn')) return;

    const row = e.target.closest('tr');
    const index = Number(row.dataset.index);

    if (!confirm('Delete this garment?')) return;

    // remove from array
    orderItems.splice(index, 1);

    // remove row
    row.remove();

    // re-index rows
    document.querySelectorAll('#savedCustomers tr').forEach((tr, i) => {
        tr.dataset.index = i;
        tr.children[0].textContent = i + 1;
    });

    updateFinalAmount();
});


document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('age-type')) return;

    selectedAge    = e.target.value;
    const garment    = document.querySelector('.garment-type').value;
    const totalInput = document.querySelector('.garment-total');

    if (!garment) {
        alert('Select garment first');
         e.target.checked = false;
        return;
    }
    if (e.target.classList.contains('age-type')) {
        document.getElementById('cloneOrderBtn').disabled = false;
    }
    // 🔹 Fetch base price from settings
fetch(`<?php echo e(route('admin.OrderManagement-price')); ?>?garment=${encodeURIComponent(garment)}&age=${encodeURIComponent(selectedAge)}`)

          .then(res => {
            if (!res.ok) throw new Error('Price not found');
            return res.json();
        })
        .then(res => {
            basePrice = Number(res.price || 0);
            updateUnitPrice();
            updateTotal();
        })
        .catch(err => {
            console.error(err);
            basePrice = 0;
            updateUnitPrice();
            updateTotal();
        });
});
// document.addEventListener('change', function (e) {

//     if (!e.target.classList.contains('addon-select')) return;

//     const addonPrice = Number(
//         e.target.selectedOptions[0].dataset.price || 0
//     );

//     const totalInput = document.querySelector('.garment-total');
//     const basePrice  = Number(totalInput.value || 0);

//     totalInput.value = basePrice + addonPrice;
// });
const cloneBaseUrl = "<?php echo e(route('admin.OrderManagement-cloneList', ['customer' => '__CID__', 'garment' => '__GARMENT__'])); ?>";

cloneBtn.addEventListener('click', function () {

    const customerId = document.getElementById('selectedCustomerId').value;
    const garment    = document.querySelector('.garment-type').value;

    if (!customerId || !garment) {
        alert('Select customer and garment first');
        return;
    }

     const url = cloneBaseUrl
        .replace('__CID__', customerId)
        .replace('__GARMENT__', encodeURIComponent(garment));


    fetch(url)
        .then(res => {
            if (!res.ok) throw new Error('Request failed');
            return res.json();
        })
        .then(orders => {

            const tbody = document.getElementById('cloneOrderList');
            tbody.innerHTML = '';

            if (!orders.length) {
                tbody.innerHTML = `
                    <tr>
                        <td colspan="4" class="text-center text-muted">
                            No previous orders found
                        </td>
                    </tr>`;
                cloneModal.show();
                return;
            }

 orders.forEach(order => {
    order.items.forEach(item => {

        let garmentLabel = item.garment_type;

        // Only for SHIRT
        if (item.garment_type.toLowerCase() === 'shirt') {
            const m = item.measurement?.measurements || {};
            const type = (m.shirt_type || '').toLowerCase();

            if (type.includes('full')) {
                garmentLabel = 'Shirt (Full)';
            } else if (type.includes('half')) {
                garmentLabel = 'Shirt (Half)';
            }
        }

        tbody.insertAdjacentHTML('beforeend', `
            <tr>
                <td>${order.order_no ?? '-'}</td>
                <td>${garmentLabel}</td>
                <td>${order.delivery_date ?? '-'}</td>
                <td>
                    <button type="button"
                            class="btn btn-sm btn-success useCloneBtn"
                            data-measurements="${encodeURIComponent(
                                JSON.stringify(item.measurement.measurements)
                            )}">
                        Use
                    </button>
                </td>
            </tr>
        `);
    });
});

            cloneModal.show();
        })
        .catch(err => {
            console.error(err);
            alert('Failed to load clone data');
        });
});
document.addEventListener('change', e => {

    if (
        e.target.classList.contains('addon-select') ||
        e.target.classList.contains('garment-qty')

    ) {
        calculateLineTotal();
    }
});

document.addEventListener('click', function (e) {

    if (!e.target.classList.contains('useCloneBtn')) return;

    const measurements = JSON.parse(
        decodeURIComponent(e.target.dataset.measurements)
    );

    console.log('APPLYING MEASUREMENTS:', measurements);

    Object.entries(measurements).forEach(([key, value]) => {

        const input = document.querySelector(
            `.measurement-input[data-key="${key}"]`
        );

        if (input) {
            input.value = value;
            input.classList.add('border-success'); // visual feedback
        }
    });

    // Close modal
    bootstrap.Modal
        .getInstance(document.getElementById('cloneModal'))
        .hide();
});
 document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('age-type')) return;

    selectedAge = e.target.value;

    document.getElementById('cloneOrderBtn').disabled = false;

    tryUpdatePrice();
});

document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('addon-select')) return;

   let totalAddonPrice = 0;

[...e.target.selectedOptions].forEach(opt => {
    if (!opt.value) return;
    totalAddonPrice += Number(opt.dataset.price || 0);
});

addonPrice = totalAddonPrice;

    updateUnitPrice();
    updateTotal();
});
document.addEventListener('input', function (e) {

    if (
        e.target.classList.contains('garment-qty')

    ) {
        updateTotal();
    }
});

document.addEventListener('change', function (e) {

    if (!e.target.classList.contains('addon-select')) return;

    const wrapper = e.target.closest('.measurement-area');
    if (!wrapper) return;

    let totalAddonPrice = 0;

    // sum prices of all selected options
    [...e.target.selectedOptions].forEach(opt => {
        totalAddonPrice += Number(opt.dataset.price || 0);
    });

    addonPrice = totalAddonPrice;

    // show summed add-on price
    wrapper.querySelector('.addon-price').value = addonPrice;

    // update prices
    updateUnitPrice(wrapper);
    updateTotal(wrapper);
});
function validateMeasurements() {

    let isValid = true;
    let firstInvalid = null;

    document.querySelectorAll('.measurement-input').forEach(input => {

        // ignore hidden fields
        if (input.type === 'hidden') return;

        // ignore disabled fields
        if (input.disabled) return;

        // value check
        if (!input.value || input.value.trim() === '') {
            input.classList.add('measure-error');
            isValid = false;

            if (!firstInvalid) {
                firstInvalid = input;
            }
        } else {
            input.classList.remove('measure-error');
        }
    });

    // focus first error
    if (firstInvalid) {
        firstInvalid.focus();
    }

    return isValid;
}


function updateUnitPrice(wrapper) {

    if (!wrapper) {
        wrapper = document.querySelector('.measurement-area');
    }
    if (!wrapper) return;

    const unitInput = wrapper.querySelector('.garment-unit-price');
    if (!unitInput) return;

    // ✅ ONLY BASE PRICE
    unitInput.value = basePrice;
}

function applyRadioMeasurement(key, value) {

    const hidden = document.querySelector(
        `.measurement-input[data-key="${key}"]`
    );

    if (!hidden) return;

    hidden.value = value;

    const container = hidden.parentElement;

    container.querySelectorAll('.measure-toggle').forEach(btn => {
        btn.classList.remove('active');

        if (btn.textContent.trim() === value.trim()) {
            btn.classList.add('active');
        }
    });
}

function updateTotal(wrapper) {

    if (!wrapper) {
        wrapper = document.querySelector('.measurement-area');
    }
    if (!wrapper) return;

    const unitPrice = Number(
        wrapper.querySelector('.garment-unit-price')?.value || 0
    );
    const qty = Number(
        wrapper.querySelector('.garment-qty')?.value || 1
    );

    const addon = Number(
        wrapper.querySelector('.addon-price')?.value || 0
    );

    // ✅ CORRECT FORMULA
    const total = (unitPrice * qty) + addon;

    wrapper.querySelector('.garment-total').value =
        Math.max(total, 0);
}
document.addEventListener('input', function (e) {
    if (e.target.classList.contains('measurement-input')) {
        if (e.target.value.trim() !== '') {
            e.target.classList.remove('measure-error');
        }
    }
});

document.addEventListener('change', function (e) {
    if (e.target.classList.contains('measurement-input')) {
        if (e.target.value.trim() !== '') {
            e.target.classList.remove('measure-error');
        }
    }
});


 document.addEventListener('click', function (e) {

     if (e.target.classList.contains('editRowBtn')) {

     editIndex = Number(e.target.dataset.index);
    const item = orderItems[editIndex];

    if (!item) {
        alert('Edit item not found');
        return;
    }

    console.log('📝 Editing item:', item);

    // 1️⃣ SHOW GARMENT SECTION
    garmentWrapper.classList.remove('d-none');

    // 2️⃣ PROFILE
    const profileSelect = document.getElementById('profileSelect');
    profileSelect.value = item.profile_id;

    // 3️⃣ AGE TYPE (SET FIRST)
    const ageSelect = document.querySelector('.age-type');
    ageSelect.value = item.age_type;

    // 4️⃣ GARMENT TYPE (THIS BUILDS UI)
    const garmentSelect = document.querySelector('.garment-type');
    if (garmentSelect) {
            garmentSelect.value = item.garment_type;
            garmentSelect.dispatchEvent(new Event('change', { bubbles: true }));
        }

    // 5️⃣ WAIT FOR UI → THEN FILL
    setTimeout(() => {

        /* ===== MEASUREMENTS ===== */
        Object.entries(item.measurements).forEach(([key, val]) => {
            const input = document.querySelector(
                `.measurement-input[data-key="${key}"]`
            );
            if (input) input.value = val;
        });

        /* ===== NOTES ===== */
        const notes = document.querySelector('.garment-notes');
        if (notes) notes.value = item.notes || '';

        /* ===== QTY ===== */
        document.querySelector('.garment-qty').value = item.qty;

        /* ===== PRICE ===== */
        document.querySelector('.garment-unit-price').value = item.unit_price;


        /* ===== ADDONS ===== */
        const addonSelect = document.querySelector('.addon-select');
        if (addonSelect && item.addons) {
            [...addonSelect.options].forEach(opt => {
                opt.selected = item.addons.some(
                    a => Number(a.addon_id) === Number(opt.value)
                );
            });
        }

        /* ===== IMAGES (SHOW PREVIEW) ===== */
        if (item.images && item.images.length) {
            const imgBox = document.getElementById('imageContainer');
            imgBox.innerHTML = '';

            item.images.forEach(img => {
                imgBox.insertAdjacentHTML('beforeend', `
                    <div class="mb-1">
                        <img src="${URL.createObjectURL(img)}"
                             style="width:70px;border:1px solid #000">
                    </div>
                `);
            });
        }

        updateTotal();

    }, 250);
 } // ⏱ CRITICAL DELAY
});

document.addEventListener('click', function (e) {

    if (!e.target.classList.contains('deleteRowBtn')) return;

    const index = Number(e.target.dataset.index);

    if (!confirm('Delete this garment?')) return;

    orderItems.splice(index, 1);
    renderOrderTable();
     resetGarmentAfterAdd();
});



function resetGarmentInputs() {


    const garmentSelect = document.querySelector('.garment-type');
    if (garmentSelect) {
        garmentSelect.value = '';
        garmentSelect.selectedIndex = 0;
    }

    const wrapper = document.querySelector('.measurement-area');
    if (!wrapper) return;

    // Clear measurement inputs
    wrapper.querySelectorAll(
        '.measurement-input, .garment-qty, .garment-total'
    ).forEach(el => {
        if (el.tagName === 'SELECT') {
            el.selectedIndex = 0;
        } else {
            el.value = '';
        }
    });

    // Reset add-ons
    wrapper.querySelectorAll('.addon-select').forEach(sel => {
        [...sel.options].forEach(o => o.selected = false);
    });

    // Reset add-on price
    wrapper.querySelectorAll('.addon-price').forEach(i => i.value = 0);

    // Reset unit price
    wrapper.querySelectorAll('.garment-unit-price').forEach(i => i.value = '');

    // Reset notes
    wrapper.querySelectorAll('.garment-notes').forEach(i => i.value = '');

    // Reset age type
    document.querySelectorAll('.age-type').forEach(el => el.value = '');

    // Reset internal JS state
    basePrice  = 0;
    addonPrice = 0;
    selectedAge = null;

    // Remove green highlight from cloned measurements
    wrapper.querySelectorAll('.border-success')
        .forEach(el => el.classList.remove('border-success'));

    // Remove extra image inputs
    const imgContainer = document.getElementById('imageContainer');
    if (imgContainer) {
        imgContainer.innerHTML = `
            <div class="input-group mb-2">
                <input type="file"
                       class="form-control reference-image"
                       accept="image/*">
                <button type="button"
                        class="btn btn-outline-primary addImageBtn">+</button>
            </div>
        `;
    }
}


});

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/order_management/add.blade.php ENDPATH**/ ?>