<?php $__env->startSection('style1'); ?>
<style>
 /* ===== TABLE BASE ===== */
.table {
    font-size: 13px;
    vertical-align: middle;
}

.table thead th {
    text-align: center;
    vertical-align: middle;
    white-space: nowrap;
}

/* ===== ROW HEIGHT & PADDING ===== */
.table td,
.table th {
    padding: 8px 10px;
}

/* ===== IMAGE COLUMN ===== */
.table td img {
    border: 1px solid #ccc;
    border-radius: 4px;
    padding: 2px;
    background: #fff;
}

/* ===== ACTION BUTTONS ===== */
.table td:last-child {
    white-space: nowrap;
    text-align: center;
}

.table td:last-child .btn {
    margin: 2px;
}

/* ===== DESCRIPTION COLUMN ===== */
.table td:nth-child(3) {
    max-width: 250px;
    white-space: normal;
    word-break: break-word;
}

/* ===== TYPES COLUMN ===== */
.table td:nth-child(4) {
    font-size: 12px;
    color: #555;
}

/* ===== PRICE COLUMN ===== */
.table td:nth-child(5) {
    font-weight: 600;
    text-align: right;
}

/* ===== HOVER EFFECT ===== */
.table tbody tr:hover {
    background-color: #f8f9fa;
}


/* ===== MOBILE RESPONSIVE ===== */
@media (max-width: 768px) {

    .table {
        font-size: 12px;
    }

    .table td img {
        width: 45px;
    }

    .table td:nth-child(3) {
        max-width: 140px;
    }
}

</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('contentarea'); ?>
<div class="container">
    <h4>Add-On Management</h4>

    <a href="<?php echo e(route('admin.AddonManagement-create')); ?>"
       class="btn btn-primary mb-3">+ Add Add-On</a>

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Description</th>
                <th>Types</th>
                <th>Price</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($addon->name); ?></td>
                <td><?php echo e($addon->description ?? '-'); ?></td>
                <td><?php echo e(is_array($addon->type_ids) ? implode(', ', $addon->type_ids) : ''); ?></td>
                <td>₹ <?php echo e($addon->price); ?></td>
                <td>
                    <?php if($addon->image): ?>
                        <img src="<?php echo e(asset('storage/app/public/'.$addon->image)); ?>" width="60">
                    <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route('admin.AddonManagement-edit',$addon)); ?>"
                       class="btn btn-sm btn-warning">Edit</a>

                    <form action="<?php echo e(route('admin.AddonManagement-destroy', $addon->id)); ?>"
      method="POST"
      onsubmit="return confirm('Delete this add-on?')">

    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>

    <button class="btn btn-danger btn-sm">
        Delete
    </button>
</form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/addon_management/index.blade.php ENDPATH**/ ?>