<?php $__env->startSection('contentarea'); ?>
<div class="container">
    <h3>Edit Customer</h3>

    <form method="POST" action="<?php echo e(route('admin.CustomerManagement-update',$customer->id)); ?>" id="customerForm">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
   <div class="col-md-6 mb-3">
    <label>Name</label>
    <input type="text" name="name" class="form-control"
           value="<?php echo e(old('name', $customer->name ?? '')); ?>">
           <small class="text-danger" id="nameError"></small>
</div>

<div class="col-md-6  mb-3">
    <label>Phone</label>
    <input type="text" name="phone" class="form-control"
           value="<?php echo e(old('phone', $customer->phone ?? '')); ?>">
    <small class="text-danger" id="phoneError"></small>

</div>

<div class="col-md-6  mb-3">
    <label>Email</label>
    <input type="email" name="email" class="form-control"
           value="<?php echo e(old('email', $customer->email ?? '')); ?>">
    <small class="text-danger" id="emailError"></small>

</div>
<div class="col-md-6  mb-3">
    <label>Address</label>
    <textarea name="address" class="form-control"><?php echo e(old('address', $customer->address ?? '')); ?></textarea>
</div>

<div class="col-md-6  mb-3">
    <label>VIP Customer</label>
    <input type="checkbox" name="is_vip" value="1"
        <?php echo e(old('is_vip', $customer->is_vip ?? false) ? 'checked' : ''); ?>>
</div>
        <button class="btn btn-primary">Update</button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script2'); ?>
<script>
$(document).ready(function () {

    // 🔹 Custom rule: phone already exists
    $.validator.addMethod("phoneExists", function (value, element) {
        let valid = true;

        $.ajax({
            url: "<?php echo e(route('admin.customer.checkPhone')); ?>",
            type: "GET",
            data: { phone: value },
            dataType: "json",
            async: false, // IMPORTANT for validation
            success: function (response) {
                if (response.exists) {
                    valid = false;
                }
            }
        });

        return valid;
    }, "Phone number already exists");

    // 🔹 Apply validation
    $("#customerForm").validate({
        ignore: [],
        rules: {
            name: {
                required: true
            },
            phone: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                phoneExists: true
            },
            email: {
                email: true
            },
            address: {
                required: true
            }
        },
        messages: {
            name: {
                required: "Please enter customer name"
            },
            phone: {
                required: "Please enter phone number",
                digits: "Phone must contain only digits",
                minlength: "Phone must be 10 digits",
                maxlength: "Phone must be 10 digits",
                phoneExists: "Phone number already exists"
            },
            email: {
                email: "Please enter a valid email address"
            },
            address: {
                required: "Please enter address"
            }
        },

        // 🔹 Place error below input (like your design)
        errorPlacement: function (error, element) {
            element.closest('.mb-3').find('small.text-danger').html(error);
        },

        // 🔹 Clear error on success
        success: function (label, element) {
            $(element).closest('.mb-3').find('small.text-danger').html('');
        }
    });

});
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/customer_management/edit.blade.php ENDPATH**/ ?>