 <!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: DejaVu Sans;
            font-size: 12px;
            line-height: 1.5;
        }

        .title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 8px;
        }

        .line {
            margin: 6px 0;
        }
    </style>
</head>
<body>

<div class="title">Siva Tailor – Customer Receipt</div>

<div class="line">
    <b>Order No:</b> <?php echo e($order->order_no); ?>

</div>

<div class="line">
    <b>Customer:</b> <?php echo e($order->customer->name); ?>

</div>

<div class="line">
    <b>Order Date:</b> <?php echo e($order->created_at->format('d-m-Y')); ?>

</div>

<div class="line">
    <b>Delivery Date:</b> <?php echo e(\Carbon\Carbon::parse($order->delivery_date)->format('d-m-Y')); ?>

</div>

<br>

<?php
    $total   = $order->items->sum('total_amount');
    $advance = $order->advance_amount ?? 0;
    $balance = $total - $advance;
?>

<div class="line">
    <b>Total Amount:</b> ₹ <?php echo e(number_format($total, 2)); ?>

</div>

<div class="line">
    <b>Advance Amount:</b> ₹ <?php echo e(number_format($advance, 2)); ?>

</div>

<div class="line">
    <b>Balance:</b> ₹ <?php echo e(number_format($balance, 2)); ?>

</div>

<br>

<div class="line">
    <b>Online Receipt:</b><br>
    <?php echo e(url('/admin/customer/receipt/'.$order->id)); ?>

</div>

</body>
</html>
<?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/order_management/receipt_pdf.blade.php ENDPATH**/ ?>