 

<?php $__env->startSection('contentarea'); ?>

<div class="card">
    <div class="card-header">
        <h4>Edit User</h4>
    </div>

    <div class="card-body">

<form id="userForm"
      action="<?php echo e(route('admin.UserManagement-update', $user->id)); ?>"
      method="POST">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>

    
    <div class="mb-3">
        <label>Name</label>
        <input type="text"
               name="name"
               class="form-control"
               value="<?php echo e($user->name); ?>">
        <small class="text-danger"></small>
    </div>

    
    <div class="mb-3">
        <label>Email</label>
        <input type="email"
               class="form-control"
               value="<?php echo e($user->email); ?>"
               readonly>
    </div>

    
    <div class="mb-3">
        <label>Phone</label>
        <input type="text"
               name="phone"
               class="form-control"
               value="<?php echo e($user->phone); ?>">
        <small class="text-danger"></small>
    </div>

    
    <div class="mb-3">
        <label>Role</label>
        <select name="role" class="form-control">
            <option value="">Select Role</option>
            <option value="admin"  <?php echo e($user->role == 'admin'  ? 'selected' : ''); ?>>Admin</option>
            <option value="tailor" <?php echo e($user->role == 'tailor' ? 'selected' : ''); ?>>Tailor</option>
            <option value="staff"  <?php echo e($user->role == 'staff'  ? 'selected' : ''); ?>>Staff</option>
        </select>
        <small class="text-danger"></small>
    </div>

    
    <div class="mb-3">
        <label class="fw-bold">Management Access</label><br>

        <?php
            $perms = $user->permissions ?? [];
        ?>

        <div class="form-check">
            <input class="form-check-input permission"
                   type="checkbox"
                   name="permissions[]"
                   value="user_management"
                   <?php echo e(in_array('user_management', $perms) ? 'checked' : ''); ?>>
            <label class="form-check-label">User Management</label>
        </div>

        <div class="form-check">
            <input class="form-check-input permission"
                   type="checkbox"
                   name="permissions[]"
                   value="customer_management"
                   <?php echo e(in_array('customer_management', $perms) ? 'checked' : ''); ?>>
            <label class="form-check-label">Customer Management</label>
        </div>

        <div class="form-check">
            <input class="form-check-input permission"
                   type="checkbox"
                   name="permissions[]"
                   value="order_management"
                   <?php echo e(in_array('order_management', $perms) ? 'checked' : ''); ?>>
            <label class="form-check-label">Order Management</label>
        </div>

        <div class="form-check">
            <input class="form-check-input permission"
                   type="checkbox"
                   name="permissions[]"
                   value="setting_management"
                   <?php echo e(in_array('setting_management', $perms) ? 'checked' : ''); ?>>
            <label class="form-check-label">Setting Management</label>
        </div>

        <div class="form-check">
            <input class="form-check-input permission"
                   type="checkbox"
                   name="permissions[]"
                   value="addon_management"
                   <?php echo e(in_array('addon_management', $perms) ? 'checked' : ''); ?>>
            <label class="form-check-label">Add-on Management</label>
        </div>

        <small class="text-danger permission-error"></small>
    </div>

    
    <div class="mb-3">
        <label>New Password (optional)</label>
        <input type="password"
               name="password"
               class="form-control">
        <small class="text-danger"></small>
    </div>

    <div class="mb-3">
        <label>Confirm New Password</label>
        <input type="password"
               name="password_confirmation"
               class="form-control">
        <small class="text-danger"></small>
    </div>

    <button class="btn btn-success">Update User</button>

</form>

    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script1'); ?>
<script>
$(document).ready(function () {

    /* 🔐 Custom validator for permissions */
    $.validator.addMethod(
        "permissionRequired",
        function () {
            return $('input[name="permissions[]"]:checked').length > 0;
        },
        "Please select at least one management access"
    );

    $("#userForm").validate({
        ignore: [],

        rules: {
            name: {
                required: true
            },
            phone: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10
            },
            role: {
                required: true
            },

            /* 🔐 Password OPTIONAL on edit */
            password: {
                minlength: 6
            },
            password_confirmation: {
                equalTo: '[name="password"]'
            },

            /* 🔐 Permissions */
            "permissions[]": {
                permissionRequired: true
            }
        },

        messages: {
            name: {
                required: "Please enter name"
            },
            phone: {
                required: "Please enter phone number",
                digits: "Phone must contain only digits",
                minlength: "Phone must be 10 digits",
                maxlength: "Phone must be 10 digits"
            },
            role: {
                required: "Please select role"
            },
            password: {
                minlength: "Password must be at least 6 characters"
            },
            password_confirmation: {
                equalTo: "Password and Confirm Password must match"
            }
        },

        /* 🔹 Error placement (same UI as add user) */
        errorPlacement: function (error, element) {

            if (element.attr("name") === "permissions[]") {
                $(".permission-error").html(error);
            } else {
                element.closest(".mb-3")
                       .find("small.text-danger")
                       .html(error);
            }
        },

        /* 🔹 Clear error */
        success: function (label, element) {

            if ($(element).attr("name") === "permissions[]") {
                $(".permission-error").html("");
            } else {
                $(element).closest(".mb-3")
                          .find("small.text-danger")
                          .html("");
            }
        }
    });

});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/user_management/edit.blade.php ENDPATH**/ ?>