 
<?php $__env->startSection('script1'); ?>

<style>
.small-table {
    font-size: 12px;
}

.small-table th,
.small-table td {
    padding: 5px 7px !important;   /* 👈 very compact */
    vertical-align: middle;
}

.small-table th {
    background: #f8f9fa;
    font-weight: 600;
}
.compact-table {
    width: 35%;              /* 🔽 reduce width */
    margin: auto;            /* center align */
}

.compact-table th,
.compact-table td {
    padding: 5px 7px;
    font-size: 12px;
}

</style>


<?php $__env->stopSection(); ?>
<?php
$measurementLabels = [
    // SHIRT
    'shirt_type'        => 'Shirt Type / சட்டை வகை',
    'height'            => 'Height / உயரம்',
    'shoulder'          => 'Shoulder / தோள்',
    'collar'            => 'Collar / காலர்',
    'kai_uyaram'        => 'Sleeve Length / கை நீளம்',
    'body_munaikai'     => 'Body (Front) / முனைக்கை',
    'body_munda'        => 'Body (Back) / முன்டை',
    'side_loose_1'      => 'Side Loose 1 / ஓரம் 1',
    'side_loose_2'      => 'Side Loose 2 / ஓரம் 2',
    'side_loose_3'      => 'Side Loose 3 / ஓரம் 3',
    'kappu'             => 'Cuff / கப்பு',
    'front_style'       => 'Front Style / முன்பக்கம்',
    'model'             => 'Model / மாடல்',

    // PANT
    'uyaram'            => 'Length / நீளம்',
    'iduppu'            => 'Waist / இடுப்பு',
    'hi_hip'            => 'High Hip / மேல் இடுப்பு',
    'low_hip'           => 'Low Hip / கீழ் இடுப்பு',
    'seat'              => 'Seat / இருக்கை',
    'thodai'            => 'Thigh / தொடை',
    'mutti'             => 'Knee / முழங்கால்',
    'bottom'            => 'Bottom / கால்திறப்பு',
    'zip_round'         => 'Zip Round / ஜிப் சுற்று',

    // BLOUSE / CHUDITHAR
    'arm_hole'          => 'Arm Hole / கை குழி',
    'sleeve_round'     => 'Sleeve Round / கை முடிவு',
    'neck_depth_front' => 'Front Neck / முன் கழுத்து',
    'neck_depth_back'  => 'Back Neck / பின் கழுத்து',
];
?>

<?php $__env->startSection('contentarea'); ?>
<div class="container">

    <h4 class="mb-3">
        ஆர்டர் / Order No : <?php echo e($order->order_no); ?>

    </h4>

    <!-- ORDER INFO -->
  <table class="table table-bordered table-sm small-table compact-table">
        <tr>
            <th width="30%">வாடிக்கையாளர் பெயர்/ Customer Name</th>
            <td><?php echo e($order->customer->name); ?></td>
        </tr>
        <tr>
            <th>முன்பணம் / Advance</th>
            <td>₹ <?php echo e(number_format($order->advance_amount, 2)); ?></td>
        </tr>
        <tr>
            <th>விநியோக தேதி / Delivery Date</th>
            <td><?php echo e($order->delivery_date); ?></td>
        </tr>
    </table>

    <!-- GARMENTS -->
    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="mb-4">

            <h6 class="mb-2 text-primary">
                உடை வகை / Garment : <?php echo e($item->garment_type); ?>

            </h6>

          <table class="table table-bordered table-sm small-table compact-table">
                <thead class="table-light">
                    <tr>
                        <th width="20%">அளவீடு / Measurement</th>
                        <th width="30%">மதிப்பு / Value</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $item->measurement->measurements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php echo e($measurementLabels[$key]
                                    ?? ucfirst(str_replace('_',' ', $key))); ?>

                            </td>
                            <td><?php echo e($value); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <a href="<?php echo e(route('admin.OrderManagement-index')); ?>"
       class="btn btn-secondary btn-sm">
        ⬅ பின்னே செல்ல / Back
    </a>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.adminmaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/cyberbahntas/tailor/resources/views/admin/order_management/view.blade.php ENDPATH**/ ?>