<?php

use App\Http\Controllers\Admin\CustomerManagementController;
use App\Http\Controllers\Admin\MeasurementManagementController;
use App\Http\Controllers\Admin\SettingManagementController;
use App\Http\Controllers\Admin\OrderManagementController;
use App\Http\Controllers\Admin\PaymentManagementController;
use App\Http\Controllers\Admin\AddonManagementController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\TestController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\UserManagementController;
use App\Http\Controllers\Admin\UserRoleController;
use App\Http\Controllers\AutomateController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
 use Illuminate\Http\Request;
use App\Models\Customer;

Route::get('/automate/createmenutopermission', [AutomateController::class, 'createmenutopermission'])->name('automate.createmenutopermission');

Route::get('clear-all', function () {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    Artisan::call('optimize:clear');
    dd("all cleared");
});

Route::get('cache-clear', function () {
    Artisan::call('cache:clear');
    dd("cache cleared");
});

Route::get('config-cache', function () {
    Artisan::call('config:cache');
    dd("Done");
});

Route::get('storage-link', function () {
    Artisan::call('storage:link');
    dd("Done");
});

Route::get('/', function () {
    return view('auth.login');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

Route::name('admin.')->middleware('auth')->prefix('admin')->group(function () {

    Route::get('/clear-data', function () {
        DB::table('entry_managements')->truncate();
        DB::table('entry_unique_details')->truncate();
        DB::table('entry_details')->truncate();

        DB::table('auctions_managements')->truncate();
        DB::table('auctions_details')->truncate();

        DB::table('weight_managements')->truncate();
        DB::table('weight_details')->truncate();

        DB::table('invoice_masters')->truncate();
        DB::table('invoice_details')->truncate();
        DB::table('invoice_masters_deleted')->truncate();
        DB::table('invoice_details_deleted')->truncate();

        DB::table('tray_balance')->truncate();
        DB::table('cash_management')->truncate();
        DB::table('cash_details')->truncate();
        DB::table('log_reports')->truncate();

        dd("all data cleared");
    })->name('clear-data');






    Route::group([' middleware' => ['auth','role:super-admin|admin']], function () {


        Route::get('/dashboard', [DashboardController::class, 'index'])->middleware(['verified'])->name('dashboard');
        // Route::resource('permissions', PermissionController::class);
        // // Route::get('permissions/{permissionId}/delete', [PermissionController::class, 'destroy']);
        // Route::delete('admin/permissions/{permissionId}', [PermissionController::class, 'destroy'])->name('admin.permissions.destroy');

        Route::resource('roles', RoleController::class);
        Route::get('roles/{roleId}/delete', [RoleController::class, 'destroy']);
        Route::get('roles/{roleId}/give-permissions', [RoleController::class, 'addPermissionToRole']);
        Route::put('roles/{roleId}/give-permissions', [RoleController::class, 'givePermissionToRole'])->name('givePermissionToRole');

        Route::resource('users', UserController::class);
        Route::get('users/{userId}/delete', [UserController::class, 'destroy']);

        // ---------------Test ROUTES----------------

        Route::get('/test', [TestController::class, 'test'])->name('test');

        // ---------------ROLES----------------

        Route::get('/UserRoles', [UserRoleController::class, 'list'])->name('UserRoles');
        Route::get('/UserRoles-list', [UserRoleController::class, 'list'])->name('UserRoles-list');
        Route::post('/UserRoles-datalist', [UserRoleController::class, 'datalist'])->name('UserRoles-datalist');
        Route::get('/UserRoles-add', [UserRoleController::class, 'add'])->name('UserRoles-add');
        Route::post('/UserRoles-add', [UserRoleController::class, 'save'])->name('UserRoles-save');
        Route::get('/UserRoles/{UserRolesId}/edit', [UserRoleController::class, 'edit'])->name('UserRoles-edit')->where('UserRolesId', '[0-9]+');
        Route::PUT('/UserRoles/{UserRolesId}', [UserRoleController::class, 'update'])->name('UserRoles-update')->where('UserRolesId', '[0-9]+');
        Route::get('/UserRoles/{UserRolesId}/view', [UserRoleController::class, 'view'])->name('UserRoles-view')->where('UserRolesId', '[0-9]+');
        Route::DELETE('/UserRoles/{UserRolesId}', [UserRoleController::class, 'destroy'])->name('UserRoles-delete')->where('UserRolesId', '[0-9]+');

        Route::get('/UserRoles-listindex', [UserRoleController::class, 'listindex'])->name('UserRoles-listindex');
        Route::post('/UserRoles-dataindex', [UserRoleController::class, 'dataindex'])->name('UserRoles-dataindex');

        // ---------------User Management Route----------------

        Route::get('/UserManagement', [UserManagementController::class, 'index'])->name('UserManagement');

        Route::get('/UserManagement-index', [UserManagementController::class, 'index'])->name('UserManagement-index');
        Route::post('/UserManagement-dataindex', [UserManagementController::class, 'dataindex'])->name('UserManagement-dataindex');
        Route::get('/UserManagement-create', [UserManagementController::class, 'create'])->name('UserManagement-create');
        Route::post('/UserManagement-store', [UserManagementController::class, 'store'])->name('UserManagement-store');
        Route::get('/UserManagement/{UserManagementId}/edit', [UserManagementController::class, 'edit'])->name('UserManagement-edit')->where('UserManagementId', '[0-9]+');
        Route::PUT('/UserManagement/{UserManagementId}', [UserManagementController::class, 'update'])->name('UserManagement-update')->where('UserManagementId', '[0-9]+');
        Route::get('/UserManagement/{UserManagementId}/view', [UserManagementController::class, 'show'])->name('UserManagement-show')->where('UserManagementId', '[0-9]+');
        Route::DELETE('/UserManagement/{UserManagementId}', [UserManagementController::class, 'destroy'])->name('UserManagement-destroy')->where('UserManagementId', '[0-9]+');

        Route::post('/check-phone', [UserManagementController::class, 'check_Phone'])->name('check-phone');
        Route::post('/edit-check-phone', [UserManagementController::class, 'edit_check_Phone'])->name('edit-check-phone');

        // ---------------Customer Management Route----------------

        Route::get('/CustomerManagement', [CustomerManagementController::class, 'index'])->name('CustomerManagement');

        Route::get('/CustomerManagement-index', [CustomerManagementController::class, 'index'])->name('CustomerManagement-index');
        Route::post('/CustomerManagement-dataindex', [CustomerManagementController::class, 'dataindex'])->name('CustomerManagement-dataindex');
        Route::get('/CustomerManagement-create', [CustomerManagementController::class, 'create'])->name('CustomerManagement-create');
        Route::post('/CustomerManagement-store', [CustomerManagementController::class, 'store'])->name('CustomerManagement-store');
        Route::get('/CustomerManagement/{CustomerManagementId}/edit', [CustomerManagementController::class, 'edit'])->name('CustomerManagement-edit')->where('CustomerManagementId', '[0-9]+');
        Route::PUT('/CustomerManagement/{CustomerManagementId}', [CustomerManagementController::class, 'update'])->name('CustomerManagement-update')->where('CustomerManagementId', '[0-9]+');
        Route::get('/CustomerManagement/{CustomerManagementId}/view', [CustomerManagementController::class, 'show'])->name('CustomerManagement-show')->where('CustomerManagementId', '[0-9]+');
        Route::DELETE('/CustomerManagement/{CustomerManagementId}', [CustomerManagementController::class, 'destroy'])->name('CustomerManagement-destroy')->where('CustomerManagementId', '[0-9]+');
        Route::post('/CustomerManagement/ajax-store',[CustomerManagementController::class, 'ajaxStore'])->name('CustomerManagement-ajaxStore');

        // ---------------Measurement Management Route----------------

        Route::get('/MeasurementManagement', [MeasurementManagementController::class, 'index'])->name('MeasurementManagement');

        Route::get('/MeasurementManagement-index', [MeasurementManagementController::class, 'index'])->name('MeasurementManagement-index');
        Route::post('/MeasurementManagement-dataindex', [MeasurementManagementController::class, 'dataindex'])->name('MeasurementManagement-dataindex');
        Route::get('/MeasurementManagement-create', [MeasurementManagementController::class, 'create'])->name('MeasurementManagement-create');
        Route::post('/MeasurementManagement-store', [MeasurementManagementController::class, 'store'])->name('MeasurementManagement-store');
        Route::get('/MeasurementManagement/{MeasurementManagementId}/edit', [MeasurementManagementController::class, 'edit'])->name('MeasurementManagement-edit')->where('MeasurementManagementId', '[0-9]+');
        Route::PUT('/MeasurementManagement/{MeasurementManagementId}', [MeasurementManagementController::class, 'update'])->name('MeasurementManagement-update')->where('MeasurementManagementId', '[0-9]+');
        Route::get('/MeasurementManagement/{MeasurementManagementId}/view', [MeasurementManagementController::class, 'show'])->name('MeasurementManagement-show')->where('MeasurementManagementId', '[0-9]+');
        Route::DELETE('/MeasurementManagement/{MeasurementManagementId}', [MeasurementManagementController::class, 'destroy'])->name('MeasurementManagement-destroy')->where('MeasurementManagementId', '[0-9]+');

        //------------------------------------Order Management-------------------

    Route::get('/OrderManagement', [OrderManagementController::class, 'index'])->name('OrderManagement');

    Route::get('/OrderManagement-index', [OrderManagementController::class, 'index'])->name('OrderManagement-index');
    Route::get('/OrderManagement-create', [OrderManagementController::class, 'create'])->name('OrderManagement-create');
    Route::post('/OrderManagement-store', [OrderManagementController::class, 'store'])->name('OrderManagement-store');
    Route::get('/OrderManagement/{order}/edit', [OrderManagementController::class, 'edit'])->name('OrderManagement-edit');
    Route::PUT('/OrderManagement/{order}', [OrderManagementController::class, 'update'])->name('OrderManagement-update')->where('OrderManagementId','[0-9]+');
    Route::get('/OrderManagement/{order}/view', [OrderManagementController::class, 'show'])->name('OrderManagement-show');
    Route::post('/OrderManagement/{order}/status', [OrderManagementController::class, 'updateStatus'])->name('OrderManagement-status');
    Route::post('/OrderManagement/save-single-customer', [OrderManagementController::class, 'saveSingleCustomer'])->name('OrderManagement-saveSingleCustomer');
     Route::DELETE('/OrderManagement/{order}', [OrderManagementController::class, 'destroy'])->name('OrderManagement-destroy');
    Route::get('/OrderManagement/{id}/print',[OrderManagementController::class, 'print'])->name('OrderManagement-print');
    Route::get('/OrderManagement/{order}/clone',[OrderManagementController::class, 'clone'])->name('admin.OrderManagement-clone');
    Route::get('/OrderManagement/clone-list/{customer}/{garment}',[OrderManagementController::class, 'cloneList'])->name('OrderManagement-cloneList');
    Route::get('/OrderManagement/price',[OrderManagementController::class, 'getPrice'])->name('OrderManagement-price');
    Route::get('/OrderManagement/customer-profiles/{customer}',[OrderManagementController::class, 'getCustomerProfiles'])->name('OrderManagement-customerProfiles');
    Route::get('/OrderManagement/measurements/latest',[OrderManagementController::class, 'latestMeasurements'])->name('OrderManagement-latestMeasurements');
    Route::post('/OrderManagement/profile-store',[OrderManagementController::class, 'storeProfile'])->name('OrderManagement-profileStore');
    Route::get('/admin/customer/{customer}/profiles',[OrderManagementController::class, 'customerProfiles'])->name('admin.OrderManagement-customerProfiles');
    Route::get('/customer/receipt/{order}',[OrderManagementController::class, 'customerReceipt'])->name('OrderManagement-customerReceipt');
    Route::get('/OrderManagement/{order}/receipt-pdf',[OrderManagementController::class, 'generateReceiptPdf'])->name('OrderManagement-receiptPdf');
    Route::get('/customer/check-phone', function (\Illuminate\Http\Request $request) {
    return response()->json([
        'exists' => \App\Models\Customer::where('phone', $request->phone)->exists()
    ]);
})->name('customer.checkPhone');
 //------------------------------------Addon Management-------------------

    Route::get('/AddonManagement', [AddonManagementController::class, 'index'])->name('AddonManagement');

    Route::get('/AddonManagement-index', [AddonManagementController::class, 'index'])->name('AddonManagement-index');
    Route::get('/AddonManagement-create', [AddonManagementController::class, 'create'])->name('AddonManagement-create');
    Route::post('/AddonManagement-store', [AddonManagementController::class, 'store'])->name('AddonManagement-store');
    Route::get('/AddonManagement/{id}/edit', [AddonManagementController::class, 'edit'])->name('AddonManagement-edit');
    Route::PUT('/AddonManagement/{id}',[AddonManagementController::class, 'update'])->name('AddonManagement-update');
    Route::get('/AddonManagement/{id}/view', [AddonManagementController::class, 'show'])->name('AddonManagement-show');
    Route::post('/AddonManagement/{id}/status', [AddonManagementController::class, 'updateStatus'])->name('AddonManagement-status');
     Route::DELETE('/AddonManagement/{id}', [AddonManagementController::class, 'destroy'])->name('AddonManagement-destroy');


    //-------------------------Payment Management--------------------
        Route::get('/PaymentManagement', [PaymentManagementController::class, 'create'])->name('PaymentManagement');
        Route::get('/payments/{order}/create', [PaymentManagementController::class, 'create'])->name('PaymentManagement-create');

        Route::post('/payments/store', [PaymentManagementController::class, 'store'])->name('PaymentManagement-store');
    //-----------------Setting Management-------------------------------------------

    Route::get('/SettingManagement', [SettingManagementController::class, 'edit'])->name('SettingManagement-edit');

    Route::post('/SettingManagement', [SettingManagementController::class, 'update'])->name('SettingManagement-update');
    Route::get('/SettingManagement/price', [SettingManagementController::class, 'getPrice']);

});



    });




require __DIR__ . '/auth.php';
