@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="mb-4">
    <h4>Vehicle Details</h4>
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <th style="width: 30%;">Car Brand</th>
                        <td>{{ $get_carbrand->brand_name ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <th>Car Model</th>
                        <td>{{ $getRow->car_model }}</td>
                    </tr>
                    <tr>
                        <th>Fuel Type</th>
                        <td class="text-capitalize">{{ $getRow->fuel_type }}</td>
                    </tr>
                    <tr>
                        <th>Seat Capacity</th>
                        <td>{{ $getRow->seat_capacity }}</td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td>
                            <span class="badge {{ $getRow->status ? 'bg-success' : 'bg-danger' }}">
                                {{ $getRow->status ? 'Enabled' : 'Disabled' }}
                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>

            <div class="mt-4">
                <a href="{{ route('admin.VehicleManagement-index') }}" class="btn btn-dark">
                    Back to List
                </a>
            </div>
        </div>
    </div>
</div>

@endsection
