 @extends('admin.layout.adminmaster')

@section('contentarea')

<div class="card">
    <div class="card-header">
        <h4>Add User</h4>
    </div>

    <div class="card-body">
<form id="userForm" action="{{ route('admin.UserManagement-store') }}" method="POST">
@csrf

<div class="mb-3">
    <label>Name</label>
    <input type="text" name="name" class="form-control">
    <small class="text-danger"></small>
</div>

<div class="mb-3">
    <label>Email</label>
    <input type="email" name="email" class="form-control">
    <small class="text-danger"></small>
</div>

<div class="mb-3">
    <label>Phone</label>
    <input type="text" name="phone" class="form-control">
    <small class="text-danger"></small>
</div>

<div class="mb-3">
    <label>Role</label>
    <select name="role" class="form-control">
        <option value="">Select Role</option>
        <option value="admin">Admin</option>
        <option value="tailor">Tailor</option>
        <option value="staff">Staff</option>
    </select>
    <small class="text-danger"></small>
</div>

{{-- 🔐 MANAGEMENT ACCESS --}}
<div class="mb-3">
    <label class="fw-bold">Management Access</label><br>

    <div class="form-check">
        <input class="form-check-input permission" type="checkbox" name="permissions[]" value="user_management">
        <label class="form-check-label">User Management</label>
    </div>
    <div class="form-check">
        <input class="form-check-input permission" type="checkbox" name="permissions[]" value="user_management">
        <label class="form-check-label">Customer Management</label>
    </div>

    <div class="form-check">
        <input class="form-check-input permission" type="checkbox" name="permissions[]" value="order_management">
        <label class="form-check-label">Order Management</label>
    </div>

    <div class="form-check">
        <input class="form-check-input permission" type="checkbox" name="permissions[]" value="addon_management">
        <label class="form-check-label">Setting Management</label>
    </div>

    <div class="form-check">
        <input class="form-check-input permission" type="checkbox" name="permissions[]" value="addon_management">
        <label class="form-check-label">Add-on Management</label>
    </div>

    <small class="text-danger permission-error"></small>
</div>

<div class="mb-3">
    <label>Password</label>
    <input type="password" name="password" class="form-control">
    <small class="text-danger"></small>
</div>

<div class="mb-3">
    <label>Confirm Password</label>
    <input type="password" name="password_confirmation" class="form-control">
    <small class="text-danger"></small>
</div>

<button class="btn btn-primary">Create User</button>
</form>
</div>
</div>

@endsection
@section('script1')
{{-- ================= JAVASCRIPT ================= --}}
<script>
$(document).ready(function () {

    // ✅ CUSTOM RULE: At least one permission
    $.validator.addMethod("permissionRequired", function () {
        return $('input[name="permissions[]"]:checked').length > 0;
    }, "Please select at least one management access");

    $("#userForm").validate({
        ignore: [],
        rules: {
            name: {
                required: true
            },
            email: {
                required: true,
                email: true
            },
            phone: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10
            },
            role: {
                required: true
            },
            password: {
                required: true,
                minlength: 6
            },
            password_confirmation: {
                required: true,
                equalTo: '[name="password"]'
            }
        },

        messages: {
            name: {
                required: "Please enter name"
            },
            email: {
                required: "Please enter email",
                email: "Please enter valid email"
            },
            phone: {
                required: "Please enter phone number",
                digits: "Phone must contain only digits",
                minlength: "Phone must be 10 digits",
                maxlength: "Phone must be 10 digits"
            },
            role: {
                required: "Please select role"
            },
            password: {
                required: "Please enter password",
                minlength: "Password must be at least 6 characters"
            },
            password_confirmation: {
                required: "Please confirm password",
                equalTo: "Password and Confirm Password must match"
            }
        },

        // 🔹 ERROR PLACEMENT (LIKE YOUR CUSTOMER FORM)
        errorPlacement: function (error, element) {

            // 🔐 permissions (checkbox group)
            if (element.hasClass('permission')) {
                $('.permission-error').html(error);
            } else {
                element.closest('.mb-3')
                    .find('small.text-danger')
                    .html(error);
            }
        },

        // 🔹 CLEAR ERROR ON SUCCESS
        success: function (label, element) {

            if ($(element).hasClass('permission')) {
                $('.permission-error').html('');
            } else {
                $(element).closest('.mb-3')
                    .find('small.text-danger')
                    .html('');
            }
        },

        submitHandler: function (form) {

            // 🔐 MANUAL CHECK FOR PERMISSIONS
            if (!$('input[name="permissions[]"]:checked').length) {
                $('.permission-error')
                    .html('Please select at least one management access');
                return false;
            }

            form.submit();
        }
    });

});
</script>
@endsection






