@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">

    <h3>Stitching Price Settings</h3>

    <form method="POST"
          action="{{ route('admin.SettingManagement-update') }}">
        @csrf

        <table class="table table-bordered mt-3">
            <thead class="table-dark">
                <tr>
                    <th>Garment</th>
                    <th>Below 5 Years (₹)</th>
                    <th>Above 5 to 16 Years (₹)</th>
                    <th>Adult (₹)</th>
                </tr>
            </thead>

            <tbody>
                @foreach($garments as $garment)
                <tr>
                    <td class="fw-semibold">{{ ucfirst($garment) }}</td>

                    @foreach($ages as $ageKey => $ageLabel)
                    <td>
                        <input type="number"
                               class="form-control"
                               name="prices[{{ $garment }}][{{ $ageKey }}]"
                               value="{{ $settings[$garment.'_'.$ageKey]->price ?? '' }}"
                               min="0">
                    </td>
                    @endforeach

                </tr>
                @endforeach
            </tbody>
        </table>

        <button class="btn btn-success">
            Update Settings
        </button>
    </form>

</div>
@endsection
