@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h4>Add Payment</h4>

    <form method="POST" action="{{ route('admin.PaymentManagement-store') }}">
        @csrf

        <input type="hidden" name="order_id" value="{{ $order->id }}">

        <div class="mb-3">
            <label>Amount</label>
            <input type="number" name="amount" step="0.01" class="form-control">
        </div>

        <div class="mb-3">
            <label>Payment Mode</label>
            <select name="payment_mode" class="form-control">
                <option value="cash">Cash</option>
                <option value="upi">UPI</option>
                <option value="card">Card</option>
            </select>
        </div>

        <div class="mb-3">
            <label>Payment Date</label>
            <input type="date" name="payment_date" class="form-control" value="{{ date('Y-m-d') }}">
        </div>

        <div class="mb-3">
            <label>Notes</label>
            <textarea name="notes" class="form-control"></textarea>
        </div>

        <button class="btn btn-success">Save Payment</button>
    </form>
</div>
@endsection
