 @extends('admin.layout.adminmaster')
@section('script1')

<style>
.small-table {
    font-size: 12px;
}

.small-table th,
.small-table td {
    padding: 5px 7px !important;   /* 👈 very compact */
    vertical-align: middle;
}

.small-table th {
    background: #f8f9fa;
    font-weight: 600;
}
.compact-table {
    width: 35%;              /* 🔽 reduce width */
    margin: auto;            /* center align */
}

.compact-table th,
.compact-table td {
    padding: 5px 7px;
    font-size: 12px;
}

</style>


@endsection
@php
$measurementLabels = [
    // SHIRT
    'shirt_type'        => 'Shirt Type / சட்டை வகை',
    'height'            => 'Height / உயரம்',
    'shoulder'          => 'Shoulder / தோள்',
    'collar'            => 'Collar / காலர்',
    'kai_uyaram'        => 'Sleeve Length / கை நீளம்',
    'body_munaikai'     => 'Body (Front) / முனைக்கை',
    'body_munda'        => 'Body (Back) / முன்டை',
    'side_loose_1'      => 'Side Loose 1 / ஓரம் 1',
    'side_loose_2'      => 'Side Loose 2 / ஓரம் 2',
    'side_loose_3'      => 'Side Loose 3 / ஓரம் 3',
    'kappu'             => 'Cuff / கப்பு',
    'front_style'       => 'Front Style / முன்பக்கம்',
    'model'             => 'Model / மாடல்',

    // PANT
    'uyaram'            => 'Length / நீளம்',
    'iduppu'            => 'Waist / இடுப்பு',
    'hi_hip'            => 'High Hip / மேல் இடுப்பு',
    'low_hip'           => 'Low Hip / கீழ் இடுப்பு',
    'seat'              => 'Seat / இருக்கை',
    'thodai'            => 'Thigh / தொடை',
    'mutti'             => 'Knee / முழங்கால்',
    'bottom'            => 'Bottom / கால்திறப்பு',
    'zip_round'         => 'Zip Round / ஜிப் சுற்று',

    // BLOUSE / CHUDITHAR
    'arm_hole'          => 'Arm Hole / கை குழி',
    'sleeve_round'     => 'Sleeve Round / கை முடிவு',
    'neck_depth_front' => 'Front Neck / முன் கழுத்து',
    'neck_depth_back'  => 'Back Neck / பின் கழுத்து',
];
@endphp

@section('contentarea')
<div class="container">

    <h4 class="mb-3">
        ஆர்டர் / Order No : {{ $order->order_no }}
    </h4>

    <!-- ORDER INFO -->
  <table class="table table-bordered table-sm small-table compact-table">
        <tr>
            <th width="30%">வாடிக்கையாளர் பெயர்/ Customer Name</th>
            <td>{{ $order->customer->name }}</td>
        </tr>
        <tr>
            <th>முன்பணம் / Advance</th>
            <td>₹ {{ number_format($order->advance_amount, 2) }}</td>
        </tr>
        <tr>
            <th>விநியோக தேதி / Delivery Date</th>
            <td>{{ $order->delivery_date }}</td>
        </tr>
    </table>

    <!-- GARMENTS -->
    @foreach($order->items as $item)
        <div class="mb-4">

            <h6 class="mb-2 text-primary">
                உடை வகை / Garment : {{ $item->garment_type }}
            </h6>

          <table class="table table-bordered table-sm small-table compact-table">
                <thead class="table-light">
                    <tr>
                        <th width="20%">அளவீடு / Measurement</th>
                        <th width="30%">மதிப்பு / Value</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($item->measurement->measurements as $key => $value)
                        <tr>
                            <td>
                                {{ $measurementLabels[$key]
                                    ?? ucfirst(str_replace('_',' ', $key)) }}
                            </td>
                            <td>{{ $value }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    @endforeach

    <a href="{{ route('admin.OrderManagement-index') }}"
       class="btn btn-secondary btn-sm">
        ⬅ பின்னே செல்ல / Back
    </a>

</div>
@endsection
