{{-- SHIRT MEASUREMENT MODAL --}}
<div class="modal fade" id="shirtMeasurementModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">
                    Shirt Measurement / சட்டை அளவுகள்
                </h5>
                <button type="button" class="btn-close"
                        data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="row" id="shirtMeasurementFields"></div>
            </div>

            <div class="modal-footer">
                <button type="button"
                        class="btn btn-primary"
                        data-bs-dismiss="modal">
                    Save Measurements
                </button>
            </div>

        </div>
    </div>
</div>


{{-- PANT MEASUREMENT MODAL --}}
<div class="modal fade" id="pantMeasurementModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">
                    Pant Measurement / பாண்ட் அளவுகள்
                </h5>
                <button type="button" class="btn-close"
                        data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="row" id="pantMeasurementFields"></div>
            </div>

            <div class="modal-footer">
                <button type="button"
                        class="btn btn-primary"
                        data-bs-dismiss="modal">
                    Save Measurements
                </button>
            </div>

        </div>
    </div>
</div>


{{-- JAVASCRIPT --}}
<script>
let garmentIndex = 0;

// Shirt measurement labels
const shirtMeasurements = [
    {key:'collar',label:'Collar / காலர்'},
    {key:'chest',label:'Chest / மார்பு'},
    {key:'waist',label:'Waist / இடுப்பு'},
    {key:'seat',label:'Seat / இருக்கை'},
    {key:'front_width',label:'Front Width / முன் அகலம்'},
    {key:'first_button',label:'First Button / முதல் பொத்தான்'},
    {key:'sleeve_length',label:'Sleeve Length / கை நீளம்'},
    {key:'short_sleeve_length',label:'Short Sleeve Length / குறுகிய கை நீளம்'},
    {key:'short_sleeve_opening',label:'Short Sleeve Opening / குறுகிய கை திறப்பு'},
    {key:'biceps',label:'Biceps / மேல் கை'},
    {key:'forearm',label:'Forearm / முன் கை'},
    {key:'arm_hole',label:'Arm Hole / கை குழி'},
    {key:'shoulder',label:'Shoulder / தோள்'},
    {key:'back_width',label:'Back Width / பின் அகலம்'},
    {key:'shirt_length_front',label:'Shirt Length (Front) / முன் நீளம்'},
    {key:'shirt_length_back',label:'Shirt Length (Back) / பின் நீளம்'},
    {key:'cuff',label:'Cuff / கை முடிவு'},
];

// Pant measurement labels
const pantMeasurements = [
    {key:'waist',label:'Waist / இடுப்பு'},
    {key:'inseam',label:'Inseam / உள்ளக நீளம்'},
    {key:'outseam',label:'Outseam / வெளிப்புற நீளம்'},
    {key:'seat',label:'Seat / இருக்கை'},
    {key:'rise',label:'Rise / உயரம்'},
    {key:'thigh',label:'Thigh / தொடை'},
    {key:'knee',label:'Knee / முழங்கால்'},
    {key:'leg_opening',label:'Leg Opening / கால்திறப்பு'},
];

// Garment type change
document.addEventListener('change', function(e){
    if(e.target.classList.contains('garment-type')){

        garmentIndex = e.target.dataset.index;

        if(e.target.value === 'Shirt'){
            loadFields(shirtMeasurements, 'shirtMeasurementFields');
            new bootstrap.Modal(
                document.getElementById('shirtMeasurementModal')
            ).show();
        }

        if(e.target.value === 'Pant'){
            loadFields(pantMeasurements, 'pantMeasurementFields');
            new bootstrap.Modal(
                document.getElementById('pantMeasurementModal')
            ).show();
        }
    }
});

// Load measurement inputs
function loadFields(fields, containerId){
    let container = document.getElementById(containerId);
    container.innerHTML = '';

    fields.forEach(field => {
        container.innerHTML += `
            <div class="col-md-3 mb-3">
                <label class="fw-bold">${field.label}</label>
                <input type="text"
                       class="form-control"
                       name="garments[${garmentIndex}][measurement][${field.key}]">
            </div>
        `;
    });
}
</script>
