 <!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .row {
            margin-bottom: 4px;
        }
        .label {
            font-weight: bold;
            width: 120px;
            display: inline-block;
        }
        img {
            width: 80px;
            height: 80px;
            margin: 4px;
            border: 1px solid #000;
            object-fit: cover;
        }
    </style>
</head>

<body onload="downloadPdf()">

<!-- 🔴 IMPORTANT: WRAPPER REQUIRED -->
<div id="receiptArea">

    <h3>Order Receipt</h3>

    <div class="row">
        <span class="label">Order No:</span> {{ $order->order_no }}
    </div>

    <div class="row">
        <span class="label">Customer:</span> {{ $order->customer->name }}
    </div>

    <div class="row">
        <span class="label">Order Date:</span>
        {{ $order->created_at->format('d-m-Y') }}
    </div>

    <div class="row">
        <span class="label">Delivery:</span>
        {{ \Carbon\Carbon::parse($order->delivery_date)->format('d-m-Y') }}
    </div>

    <hr>

    @foreach($order->items as $item)
        <p>
            <strong>{{ $item->garment_type }}</strong>
            (Qty: {{ $item->quantity }})
        </p>

        @php
            $images = is_string($item->reference_image)
                ? json_decode($item->reference_image, true)
                : $item->reference_image;
        @endphp

        @if(is_array($images))
            @foreach($images as $img)
                <img src="{{ asset('storage/'.$img) }}">
            @endforeach
        @endif

        <hr>
    @endforeach

    <p>
        <strong>Total:</strong>
        ₹{{ number_format($order->items->sum('total_amount'), 2) }}
    </p>

</div>

<!-- ✅ jsPDF + html2canvas -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script>
async function downloadPdf() {

    const { jsPDF } = window.jspdf;
    const receipt = document.getElementById('receiptArea');

    if (!receipt) {
        alert('Receipt not found');
        return;
    }

    const canvas = await html2canvas(receipt, {
        scale: 2
    });

    const imgData = canvas.toDataURL('image/png');

    const pdf = new jsPDF('p', 'mm', 'a4');
    const pdfWidth = 210;
    const pdfHeight = (canvas.height * pdfWidth) / canvas.width;

    pdf.addImage(imgData, 'PNG', 0, 0, pdfWidth, pdfHeight);
    pdf.save('order_receipt_{{ $order->order_no }}.pdf');
}
</script>

</body>
</html>
