@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h4>Measurement Details</h4>
 @php
    function showValue($value, $unit) {
        if ($value === null) return '-';

        return $unit === 'cm'
            ? round($value * 2.54, 2) . ' cm'
            : round($value, 2) . ' inch';
    }
@endphp

<table class="table table-bordered">
    <tr>
        <td>Customer / வாடிக்கையாளர்</td>
        <th>{{ $measurement->customer?->name ?? 'N/A' }}</th>
    </tr>

    <tr>
        <td>Garment Type / உடை வகை</td>
        <th>{{ $measurement->garment_type }}</th>
    </tr>

    <tr>
        <td>Unit / அளவீட்டு அலகு</td>
        <th>{{ strtoupper($measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Chest / மார்பு</td>
        <th>{{ showValue($measurement->chest, $measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Waist / இடுப்பு</td>
        <th>{{ showValue($measurement->waist, $measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Hip / தொடை</td>
        <th>{{ showValue($measurement->hip, $measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Shoulder / தோள்பட்டை</td>
        <th>{{ showValue($measurement->shoulder, $measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Sleeve / கை நீளம்</td>
        <th>{{ showValue($measurement->sleeve, $measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Length / நீளம்</td>
        <th>{{ showValue($measurement->length, $measurement->unit) }}</th>
    </tr>

    <tr>
        <td>Notes / குறிப்புகள்</td>
        <th>{{ $measurement->notes ?? '-' }}</th>
    </tr>
</table>
@if($draft && $measurement->garment_type === 'Blouse')
    <h5 class="mt-4">Blouse Cutting Draft (Scale)</h5>

    <canvas id="blouseDraft"
            width="650"
            height="650"
            style="border:1px solid #ccc"></canvas>

    <script>
        const scale = 10; // 1 inch = 10px

        const bustQuarter = {{ $draft['bustQuarter'] }} * scale;
        const length      = {{ $draft['length'] }} * scale;
        const shoulder    = {{ $draft['shoulder'] }} * scale;
        const armhole     = {{ $draft['armhole'] }} * scale;
        const neckWidth   = {{ $draft['neckWidth'] }} * scale;
        const neckDepth   = {{ $draft['neckDepth'] }} * scale;

        const canvas = document.getElementById("blouseDraft");
        const ctx = canvas.getContext("2d");

        ctx.clearRect(0, 0, canvas.width, canvas.height);

        const startX = 90;
        const startY = 80;

        ctx.font = "10px Arial";

        // =====================
        // RULER (VERTICAL)
        // =====================
        for (let i = 0; i <= length / scale; i++) {
            const y = startY + (i * scale);
            ctx.beginPath();
            ctx.moveTo(startX - 10, y);
            ctx.lineTo(startX - 20, y);
            ctx.stroke();
            ctx.fillText(i + '"', startX - 40, y + 3);
        }

        // =====================
        // BODY RECTANGLE
        // =====================
        ctx.strokeRect(startX, startY, bustQuarter, length);

        // Shoulder line
        ctx.beginPath();
        ctx.moveTo(startX, startY);
        ctx.lineTo(startX + shoulder, startY);
        ctx.stroke();

        // Armhole guide
        ctx.beginPath();
        ctx.moveTo(startX + bustQuarter, startY + armhole);
        ctx.lineTo(startX + bustQuarter - 30, startY + armhole);
        ctx.stroke();

        // Neck width
        ctx.beginPath();
        ctx.moveTo(startX, startY);
        ctx.lineTo(startX + neckWidth, startY);
        ctx.stroke();

        // Neck depth
        ctx.beginPath();
        ctx.moveTo(startX, startY);
        ctx.lineTo(startX, startY + neckDepth);
        ctx.stroke();

        // Labels
        ctx.fillText("Bust", startX + bustQuarter + 5, startY + 10);
        ctx.fillText("Armhole", startX + bustQuarter + 5, startY + armhole);
        ctx.fillText("Neck", startX + neckWidth + 5, startY + 10);
    </script>
@endif

@if($draft && $measurement->garment_type === 'Pant')
    <h5 class="mt-4">Pant Cutting Draft (Scale)</h5>

    <canvas id="pantDraft"
            width="700"
            height="800"
            style="border:1px solid #ccc"></canvas>

    <script>
        const scale = 10; // 1 inch = 10px

        const waistQuarter = {{ $draft['waistQuarter'] }} * scale;
        const hipQuarter   = {{ $draft['hipQuarter'] }} * scale;
        const length       = {{ $draft['length'] }} * scale;
        const kneeLine     = {{ $draft['kneeLine'] }} * scale;
        const seatLine     = {{ $draft['seatLine'] }} * scale;

        const canvas = document.getElementById("pantDraft");
        const ctx = canvas.getContext("2d");

        ctx.clearRect(0, 0, canvas.width, canvas.height);

        const startX = 100;
        const startY = 60;

        // =====================
        // RULERS
        // =====================
        ctx.font = "10px Arial";

        // Vertical ruler
        for (let i = 0; i <= length / scale; i++) {
            const y = startY + (i * scale);
            ctx.beginPath();
            ctx.moveTo(startX - 10, y);
            ctx.lineTo(startX - 20, y);
            ctx.stroke();
            ctx.fillText(i + '"', startX - 40, y + 3);
        }

        // =====================
        // BODY RECTANGLE
        // =====================
        ctx.strokeRect(startX, startY, hipQuarter, length);

        // Waist line
        ctx.beginPath();
        ctx.moveTo(startX, startY);
        ctx.lineTo(startX + waistQuarter, startY);
        ctx.stroke();

        // Seat line
        ctx.beginPath();
        ctx.moveTo(startX, startY + seatLine);
        ctx.lineTo(startX + hipQuarter, startY + seatLine);
        ctx.stroke();

        // Knee line
        ctx.beginPath();
        ctx.moveTo(startX, startY + kneeLine);
        ctx.lineTo(startX + hipQuarter, startY + kneeLine);
        ctx.stroke();

        // Labels
        ctx.fillText("Waist", startX + waistQuarter + 5, startY + 10);
        ctx.fillText("Seat", startX + hipQuarter + 5, startY + seatLine + 5);
        ctx.fillText("Knee", startX + hipQuarter + 5, startY + kneeLine + 5);
    </script>
@endif


 <script>
    const scale = 10; // 1 inch = 10px

    const width    = {{ $draft['width'] }} * scale;
    const length   = {{ $draft['length'] }} * scale;
    const shoulder = {{ $draft['shoulder'] }} * scale;
    const armhole  = {{ $draft['armhole'] }} * scale;

    const canvas = document.getElementById("shirtDraft");
    const ctx = canvas.getContext("2d");

    ctx.clearRect(0, 0, canvas.width, canvas.height);

    const startX = 80;
    const startY = 80;

    // =========================
    // DRAW RULERS
    // =========================
    ctx.font = "10px Arial";
    ctx.fillStyle = "#000";

    // Horizontal ruler (top)
    for (let i = 0; i <= width / scale; i++) {
        const x = startX + (i * scale);

        ctx.beginPath();
        ctx.moveTo(x, startY - 10);
        ctx.lineTo(x, startY - 20);
        ctx.stroke();

        ctx.fillText(i + '"', x - 5, startY - 25);
    }

    // Vertical ruler (left)
    for (let i = 0; i <= length / scale; i++) {
        const y = startY + (i * scale);

        ctx.beginPath();
        ctx.moveTo(startX - 10, y);
        ctx.lineTo(startX - 20, y);
        ctx.stroke();

        ctx.fillText(i + '"', startX - 35, y + 3);
    }

    // =========================
    // SHIRT BODY
    // =========================
    ctx.strokeRect(startX, startY, width, length);

    // Shoulder line
    ctx.beginPath();
    ctx.moveTo(startX, startY);
    ctx.lineTo(startX + shoulder, startY);
    ctx.stroke();

    // Armhole guide
    ctx.beginPath();
    ctx.moveTo(startX + width, startY + armhole);
    ctx.lineTo(startX + width - 30, startY + armhole);
    ctx.stroke();
</script>


</div>
@endsection
