@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h4>Edit Measurement</h4>
    @php
    function displayValue($value, $unit) {
        if ($value === null) return null;

        return $unit === 'cm'
            ? round($value * 2.54, 2)   // inch → cm
            : round($value, 2);         // inch → inch
    }
@endphp
 <form method="POST" action="{{ route('admin.MeasurementManagement-update', $measurement->id) }}">
    @csrf
    @method('PUT')

    <div class="row">

        <!-- Customer -->
        <div class="col-12 col-md-4 mb-3">
            <label>Customer <small class="text-muted">/ வாடிக்கையாளர்</small></label>
            <select name="customer_id" class="form-control">
                @foreach($customers as $customer)
                    <option value="{{ $customer->id }}"
                        {{ old('customer_id', $measurement->customer_id) == $customer->id ? 'selected' : '' }}>
                        {{ $customer->name }} ({{ $customer->phone }})
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Garment Type -->
        <div class="col-12 col-md-4 mb-3">
            <label>Garment Type <small class="text-muted">/ உடை வகை</small></label>
            <select name="garment_type" class="form-control">
                @foreach(['Shirt','Pant','Suit','Blouse'] as $type)
                    <option value="{{ $type }}"
                        {{ old('garment_type', $measurement->garment_type) == $type ? 'selected' : '' }}>
                        {{ $type }}
                    </option>
                @endforeach
            </select>
        </div>

            <div class="col-12 col-md-4 mb-3">
            <label>
                Unit <small class="text-muted">/ அளவீட்டு அலகு</small>
            </label>
            <select name="unit" id="unit" class="form-control">
                <option value="inch"
                    {{ old('unit', $measurement->unit) == 'inch' ? 'selected' : '' }}>
                    Inch / இஞ்ச்
                </option>

                <option value="cm"
                    {{ old('unit', $measurement->unit) == 'cm' ? 'selected' : '' }}>
                    CM / செ.மீ
                </option>
            </select>
        </div>

        <!-- Measurement Labels -->
        @php
            $labels = [
                'chest'    => 'Chest / மார்பு',
                'waist'    => 'Waist / இடுப்பு',
                'hip'      => 'Hip / தொடை',
                'shoulder' => 'Shoulder / தோள்பட்டை',
                'sleeve'   => 'Sleeve / கை நீளம்',
                'length'   => 'Length / நீளம்',
            ];
        @endphp

      @foreach($labels as $field => $label)
    <div class="col-12 col-md-4 mb-3">
        <label>
            {{ $label }}
            <small class="text-muted">
                ({{ strtoupper($measurement->unit) }})
            </small>
        </label>

        <input type="number"
               step="0.01"
               name="{{ $field }}"
               value="{{ old($field, displayValue($measurement->$field, $measurement->unit)) }}"
               class="form-control">
    </div>
        @endforeach

        <!-- Notes -->
        <div class="col-12 col-md-4 mb-3">
            <label>Notes <small class="text-muted">/ குறிப்புகள்</small></label>
            <textarea name="notes" class="form-control" rows="4">{{ old('notes', $measurement->notes) }}</textarea>
        </div>

    </div>

    <button class="btn btn-primary mt-2">Update</button>
</form>

</div>
@endsection
@section('script1')

    <script>
document.addEventListener('DOMContentLoaded', function () {

    const unitSelect = document.getElementById('unit');
    if (!unitSelect) return;

    let currentUnit = unitSelect.value;

    unitSelect.addEventListener('change', function () {
        const newUnit = this.value;

        if (currentUnit === newUnit) return;

        document.querySelectorAll('input[data-field="measurement"]').forEach(input => {
            if (!input.value) return;

            let value = parseFloat(input.value);
            if (isNaN(value)) return;

            if (newUnit === 'cm' && currentUnit === 'inch') {
                value = value * 2.54;
            } else if (newUnit === 'inch' && currentUnit === 'cm') {
                value = value / 2.54;
            }

            input.value = value.toFixed(2);
        });

        currentUnit = newUnit;
    });

});
</script>

@endsection
