@extends('admin.layout.adminmaster')

@section('style1')
<style>
.containerbutton {
    display: flex;
    margin-bottom: 10px;
}
.prodName{
    font-size: 16px;
}
</style>
@endsection

@section('contentarea')

<div id="borderedTable" class="mb-5">
    <div class="containerbutton">
        <h4>Customer Details</h4>
    </div>

    <div class="card">
        <div class="card-body">



            <table class="table table-bordered" style="border-collapse: collapse; width: 70%;">
                <tbody>

                    <tr>
                        <td>Customer Name</td>
                        <th>{{ $customer->name }}</th>
                    </tr>

                    <tr>
                        <td>Phone Number</td>
                        <th>{{ $customer->phone }}</th>
                    </tr>
                       <tr>
                        <td>Email</td>
                        <th>{{ $customer->email}}</th>
                    </tr>
                    <tr>
                        <td>Address</td>
                        <th>{{ $customer->address ?? '-' }}</th>
                    </tr>

                    <tr>
                        <td>VIP Customer</td>
                        <th>
                            @if($customer->is_vip)
                                <span class="badge bg-success">YES</span>
                            @else
                                <span class="badge bg-secondary">NO</span>
                            @endif
                        </th>
                    </tr>



                    <tr>
                        <td>Arrived Date</td>
                        <th>{{ $customer->created_at->format('d-m-Y h:i A') }}</th>
                    </tr>

                </tbody>
            </table>
              <a href="{{ route('admin.CustomerManagement-index') }}"
               style="float:left"
               class="btn btn-dark mb-1">
                BACK
            </a>
    </div>
      </div>
        </div>
@endsection
