@extends('admin.layout.adminmaster')
 
@section('contentarea')
<div class="container">
    <h3>Customer Management</h3>

    <a href="{{ route('admin.CustomerManagement-create') }}" class="btn btn-primary mb-3">
        + Add Customer
    </a>

<form method="GET"
      action="{{ route('admin.CustomerManagement-index') }}"
      class="row mb-3">

    <div class="col-md-4">
        <input type="text"
               name="search"
               value="{{ $search }}"
               class="form-control"
               placeholder="Search by name or phone">
    </div>

    <div class="col-md-2">
        <button class="btn btn-primary">
            Search
        </button>

        <a href="{{ route('admin.CustomerManagement-index') }}"
           class="btn btn-secondary">
            Reset
        </a>
    </div>
</form>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>SNo</th>
                <th>Name</th>
                <th>Phone</th>
                 <th>Email</th>
                <th>Address</th>
                <th>VIP</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($customers as $customer)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $customer->name }}</td>
                <td>{{ $customer->phone }}</td>
                <td>{{ $customer->email }}</td>
                <td>{{ $customer->address }}</td>
                <td>
                    @if($customer->is_vip)
                        <span class="badge bg-success">VIP</span>s
                    @else
                        <span class="badge bg-secondary">Regular</span>
                    @endif
                </td>
                <td>
                    <a href="{{ route('admin.CustomerManagement-edit', $customer) }}" class="btn btn-sm btn-warning">Edit</a>
                        <a href="{{ route('admin.CustomerManagement-show', $customer) }}" class="btn btn-sm btn-warning">show</a>

                <form action="{{ route('admin.CustomerManagement-destroy', $customer->id) }}"
                    method="POST"
                    class="d-inline"
                    onsubmit="return confirm('Are you sure?')">
                    @csrf
                    @method('DELETE')

                    <button type="submit" class="btn btn-danger btn-sm">
                        Delete
                    </button>
                </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>


</div>
@endsection
