@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h3>Add Customer</h3>

    <form method="POST"
          action="{{ route('admin.CustomerManagement-store') }}"
          id="customerForm">
        @csrf

        <div class="row">
            <div class="col-md-3 mb-3">
                <label>Name</label>
                <input type="text" name="name" id="name" class="form-control">
                <small class="text-danger" id="nameError"></small>
            </div>

            <div class="col-md-3 mb-3">
                <label>Phone</label>
                <input type="text" name="phone" id="phone" class="form-control">
                <small class="text-danger" id="phoneError"></small>
            </div>

            <div class="col-md-3 mb-3">
                <label>Email</label>
                <input type="text" name="email" id="email" class="form-control">
                <small class="text-danger" id="emailError"></small>
            </div>
        </div>

        <div class="row">
            <div class="col-md-4 mb-3">
                <label>Address</label>
                <textarea name="address" class="form-control" rows="3"></textarea>
            </div>

            <div class="col-md-4 mb-3 d-flex align-items-center">
                <div class="form-check mt-4">
                    <input type="checkbox" name="is_vip" value="1" class="form-check-input">
                    <label class="form-check-label">VIP Customer</label>
                </div>
            </div>
        </div>

        <button class="btn btn-success">Save</button>
    </form>
</div>
@endsection
@section('script2')
<script>
$(document).ready(function () {

    // 🔹 Custom rule: phone already exists
    $.validator.addMethod("phoneExists", function (value, element) {
        let valid = true;

        $.ajax({
            url: "{{ route('admin.customer.checkPhone') }}",
            type: "GET",
            data: { phone: value },
            dataType: "json",
            async: false, // IMPORTANT for validation
            success: function (response) {
                if (response.exists) {
                    valid = false;
                }
            }
        });

        return valid;
    }, "Phone number already exists");

    // 🔹 Apply validation
    $("#customerForm").validate({
        ignore: [],
        rules: {
            name: {
                required: true
            },
            phone: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                phoneExists: true
            },
            email: {
                email: true
            },
            address: {
                required: true
            }
        },
        messages: {
            name: {
                required: "Please enter customer name"
            },
            phone: {
                required: "Please enter phone number",
                digits: "Phone must contain only digits",
                minlength: "Phone must be 10 digits",
                maxlength: "Phone must be 10 digits",
                phoneExists: "Phone number already exists"
            },
            email: {
                email: "Please enter a valid email address"
            },
            address: {
                required: "Please enter address"
            }
        },

        // 🔹 Place error below input (like your design)
        errorPlacement: function (error, element) {
            element.closest('.mb-3').find('small.text-danger').html(error);
        },

        // 🔹 Clear error on success
        success: function (label, element) {
            $(element).closest('.mb-3').find('small.text-danger').html('');
        }
    });

});
</script>
@endsection

