<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Madurai City Limited Driver Map</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .header {
            background: linear-gradient(135deg, #1a2a6c, #b21f1f, #1a2a6c);
            color: white;
            padding: 20px 0;
            margin-bottom: 25px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .card {
            border-radius: 15px;
            box-shadow: 0 6px 15px rgba(0,0,0,0.08);
            margin-bottom: 25px;
            border: none;
            overflow: hidden;
            transition: transform 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
        }
        .card-header {
            background: linear-gradient(135deg, #3498db, #2c3e50);
            color: white;
            font-weight: 600;
            padding: 15px 20px;
            border-radius: 15px 15px 0 0 !important;
        }
        #map {
            height: 500px;
            width: 100%;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            margin-top: 15px;
        }
        .driver-card {
            background: linear-gradient(to right, #ffffff, #f8f9fa);
            border-left: 4px solid #3498db;
            border-radius: 8px;
        }
        .online-status {
            display: inline-block;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-right: 8px;
        }
        .online {
            background-color: #2ecc71;
        }
        .offline {
            background-color: #e74c3c;
        }
        .city-boundary {
            background: linear-gradient(to right, #ff9966, #ff5e62);
        }
        .stats-card {
            color: white;
            text-align: center;
            padding: 20px 15px;
            border-radius: 12px;
            margin-bottom: 20px;
        }
        .stats-card i {
            font-size: 2.5rem;
            margin-bottom: 15px;
        }
        .stats-card h2 {
            font-size: 2.2rem;
            font-weight: 700;
            margin: 5px 0;
        }
        .stats-card p {
            opacity: 0.9;
            margin: 0;
        }
        .driver-list {
            max-height: 400px;
            overflow-y: auto;
        }
        .form-control, .form-select {
            border-radius: 8px;
            padding: 10px 15px;
            border: 1px solid #ced4da;
            transition: all 0.3s;
        }
        .form-control:focus, .form-select:focus {
            box-shadow: 0 0 0 0.25rem rgba(52, 152, 219, 0.25);
            border-color: #3498db;
        }
        .btn-primary {
            background: linear-gradient(135deg, #3498db, #2c3e50);
            border: none;
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(52, 152, 219, 0.4);
        }
        .legend {
            background: white;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            position: absolute;
            bottom: 30px;
            right: 20px;
            z-index: 1000;
        }
        .legend-item {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        .legend-color {
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 10px;
        }
        .map-container {
            position: relative;
        }
        .highlight {
            animation: pulse 2s infinite;
        }
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1><i class="bi bi-geo-alt"></i> Madurai City Limited Driver Map</h1>
                    <p class="lead mb-0">Track drivers within Madurai city boundaries in real-time</p>
                </div>
                <div class="col-md-4 text-md-end">
                    <div class="d-inline-block bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <span class="online-status online"></span>
                        <span id="online-count">8</span> drivers online
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-map"></i> Madurai City Map with Driver Locations
                    </div>
                    <div class="card-body">
                        <div class="map-container">
                            <div id="map"></div>
                            <div class="legend">
                                <h6><i class="bi bi-info-circle"></i> Map Legend</h6>
                                <div class="legend-item">
                                    <div class="legend-color" style="background-color: #2ecc71;"></div>
                                    <span>Driver (Online)</span>
                                </div>
                                <div class="legend-item">
                                    <div class="legend-color" style="background-color: #e74c3c;"></div>
                                    <span>Driver (Offline)</span>
                                </div>
                                <div class="legend-item">
                                    <div class="legend-color" style="background-color: #3498db;"></div>
                                    <span>Pickup Location</span>
                                </div>
                                <div class="legend-item">
                                    <div class="legend-color" style="background-color: #ff5e62;"></div>
                                    <span>Madurai Boundary</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="stats-card" style="background: linear-gradient(135deg, #3498db, #2c3e50);">
                            <i class="bi bi-car-front"></i>
                            <h2>42</h2>
                            <p>Total Drivers</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stats-card" style="background: linear-gradient(135deg, #2ecc71, #27ae60);">
                            <i class="bi bi-check-circle"></i>
                            <h2>8</h2>
                            <p>Active Today</p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="stats-card" style="background: linear-gradient(135deg, #9b59b6, #8e44ad);">
                            <i class="bi bi-clock-history"></i>
                            <h2>14</h2>
                            <p>Avg. Trips/Day</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <i class="bi bi-geo"></i> Set Pickup Location
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">From Location</label>
                            <input type="text" id="fromAddress" class="form-control" placeholder="Enter starting location">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">To Location</label>
                            <input type="text" id="toAddress" class="form-control" placeholder="Enter destination location">
                        </div>
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="form-label">Booking Date</label>
                                <div class="input-group">
                                    <input type="date" class="form-control" value="2023-07-15">
                                    <span class="input-group-text"><i class="bi bi-calendar"></i></span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Booking Time</label>
                                <div class="input-group">
                                    <input type="time" class="form-control" value="14:30">
                                    <span class="input-group-text"><i class="bi bi-clock"></i></span>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn-primary w-100 mt-3">
                            <i class="bi bi-search"></i> Find Available Drivers
                        </button>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <span><i class="bi bi-people"></i> Online Drivers in Madurai</span>
                        <span class="badge bg-success">8 Active</span>
                    </div>
                    <div class="card-body driver-list">
                        <div class="driver-card p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-1">Rajesh Kumar</h5>
                                    <div class="d-flex align-items-center mb-1">
                                        <span class="online-status online"></span>
                                        <span>Online • 3.2 km away</span>
                                    </div>
                                    <div class="text-muted">
                                        <i class="bi bi-car-front-fill"></i> Tata Indica • TN 58 AB 1234
                                    </div>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary">4.8</span>
                                    <div class="mt-1">
                                        <button class="btn btn-sm btn-success">
                                            <i class="bi bi-telephone"></i> Call
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="driver-card p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-1">Muthu Vel</h5>
                                    <div class="d-flex align-items-center mb-1">
                                        <span class="online-status online"></span>
                                        <span>Online • 1.8 km away</span>
                                    </div>
                                    <div class="text-muted">
                                        <i class="bi bi-car-front-fill"></i> Maruti Swift • TN 59 CD 5678
                                    </div>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary">4.9</span>
                                    <div class="mt-1">
                                        <button class="btn btn-sm btn-success">
                                            <i class="bi bi-telephone"></i> Call
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="driver-card p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-1">Arun Prakash</h5>
                                    <div class="d-flex align-items-center mb-1">
                                        <span class="online-status online"></span>
                                        <span>Online • 5.1 km away</span>
                                    </div>
                                    <div class="text-muted">
                                        <i class="bi bi-car-front-fill"></i> Hyundai i20 • TN 64 EF 9012
                                    </div>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary">4.7</span>
                                    <div class="mt-1">
                                        <button class="btn btn-sm btn-success">
                                            <i class="bi bi-telephone"></i> Call
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="driver-card p-3 mb-3">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="mb-1">Senthil Nathan</h5>
                                    <div class="d-flex align-items-center mb-1">
                                        <span class="online-status online"></span>
                                        <span>Online • 0.9 km away</span>
                                    </div>
                                    <div class="text-muted">
                                        <i class="bi bi-car-front-fill"></i> Toyota Etios • TN 57 GH 3456
                                    </div>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-primary">4.6</span>
                                    <div class="mt-1">
                                        <button class="btn btn-sm btn-success">
                                            <i class="bi bi-telephone"></i> Call
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <footer class="bg-dark text-white py-4 mt-5">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5>Madurai City Limited Driver Map</h5>
                    <p>Track drivers within Madurai city boundaries in real-time. Drivers automatically switch to online status when inside the defined city region.</p>
                </div>
                <div class="col-md-3">
                    <h5>Key Locations</h5>
                    <ul class="list-unstyled">
                        <li><i class="bi bi-geo-alt"></i> Othakadai Bus Stop</li>
                        <li><i class="bi bi-geo-alt"></i> Kadhakaman</li>
                        <li><i class="bi bi-geo-alt"></i> Viraganoor Ring Road</li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h5>Contact</h5>
                    <ul class="list-unstyled">
                        <li><i class="bi bi-envelope"></i> support@maduraitaxi.com</li>
                        <li><i class="bi bi-telephone"></i> +91 9876543210</li>
                        <li><i class="bi bi-geo"></i> Madurai, Tamil Nadu</li>
                    </ul>
                </div>
            </div>
            <hr class="my-4 bg-light">
            <div class="text-center">
                <p class="mb-0">© 2023 Madurai Taxi Services. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        function initMap() {
            // Madurai coordinates (center)
            const madurai = { lat: 9.9252, lng: 78.1198 };
            
            // Create map
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 13,
                center: madurai,
                mapTypeControl: true,
                streetViewControl: false,
                fullscreenControl: true,
                mapTypeControlOptions: {
                    style: google.maps.MapTypeControlStyle.HORIZONTAL_BAR,
                    position: google.maps.ControlPosition.TOP_RIGHT
                },
                styles: [
                    {
                        "featureType": "administrative",
                        "elementType": "labels.text.fill",
                        "stylers": [{"color": "#444444"}]
                    },
                    {
                        "featureType": "landscape",
                        "elementType": "all",
                        "stylers": [{"color": "#f2f2f2"}]
                    },
                    {
                        "featureType": "poi",
                        "elementType": "all",
                        "stylers": [{"visibility": "off"}]
                    },
                    {
                        "featureType": "road",
                        "elementType": "all",
                        "stylers": [{"saturation": -100}, {"lightness": 45}]
                    },
                    {
                        "featureType": "road.highway",
                        "elementType": "all",
                        "stylers": [{"visibility": "simplified"}]
                    },
                    {
                        "featureType": "road.arterial",
                        "elementType": "labels.icon",
                        "stylers": [{"visibility": "off"}]
                    },
                    {
                        "featureType": "transit",
                        "elementType": "all",
                        "stylers": [{"visibility": "off"}]
                    },
                    {
                        "featureType": "water",
                        "elementType": "all",
                        "stylers": [{"color": "#3498db"}, {"visibility": "on"}]
                    }
                ]
            });

            // Define Madurai city boundary (approximation)
            const maduraiBoundary = new google.maps.Polygon({
                paths: [
                    {lat: 9.93900, lng: 78.09420}, // North-West
                    {lat: 9.93900, lng: 78.15000}, // North-East
                    {lat: 9.88000, lng: 78.15000}, // South-East
                    {lat: 9.88000, lng: 78.09420}, // South-West
                    {lat: 9.93900, lng: 78.09420}  // Close polygon
                ],
                strokeColor: "#FF0000",
                strokeOpacity: 0.8,
                strokeWeight: 2,
                fillColor: "#FF0000",
                fillOpacity: 0.1,
                map: map
            });

            // Add markers for key locations
            const locations = [
                {name: "Othakadai Bus Stop", lat: 9.93900, lng: 78.09420},
                {name: "Kadhakaman", lat: 9.93500, lng: 78.11000},
                {name: "Oomachikulam", lat: 9.93000, lng: 78.12500},
                {name: "Panakadi", lat: 9.92500, lng: 78.13500},
                {name: "Chikartharachavadi", lat: 9.92000, lng: 78.14500},
                {name: "Vilakudi", lat: 9.91500, lng: 78.14000},
                {name: "Queenmina School", lat: 9.91000, lng: 78.13000},
                {name: "Nagamalai Puthukottai", lat: 9.90500, lng: 78.12000},
                {name: "Mullai Nagar", lat: 9.90000, lng: 78.11000},
                {name: "Airport", lat: 9.89500, lng: 78.10000},
                {name: "Chinthamani Signal", lat: 9.89000, lng: 78.09500},
                {name: "Viraganoor Ring Road", lat: 9.88500, lng: 78.09000}
            ];

            locations.forEach(location => {
                new google.maps.Marker({
                    position: {lat: location.lat, lng: location.lng},
                    map: map,
                    title: location.name,
                    icon: {
                        path: google.maps.SymbolPath.CIRCLE,
                        fillColor: "#3498db",
                        fillOpacity: 1,
                        strokeColor: "#ffffff",
                        strokeWeight: 1,
                        scale: 6
                    }
                });
            });

            // Driver locations (some inside, some outside the boundary)
            const drivers = [
                {name: "Rajesh Kumar", lat: 9.9292, lng: 78.1228, online: true, plate: "TN 58 AB 1234"},
                {name: "Muthu Vel", lat: 9.9215, lng: 78.1175, online: true, plate: "TN 59 CD 5678"},
                {name: "Arun Prakash", lat: 9.9180, lng: 78.1250, online: true, plate: "TN 64 EF 9012"},
                {name: "Senthil Nathan", lat: 9.9320, lng: 78.1150, online: true, plate: "TN 57 GH 3456"},
                {name: "Karthik", lat: 9.9350, lng: 78.1050, online: true, plate: "TN 60 IJ 6789"},
                {name: "Vijay", lat: 9.9250, lng: 78.1300, online: true, plate: "TN 61 KL 0123"},
                {name: "Prabhu", lat: 9.9150, lng: 78.1200, online: true, plate: "TN 62 MN 4567"},
                {name: "Manikandan", lat: 9.9050, lng: 78.1100, online: true, plate: "TN 63 OP 8901"},
                // Drivers outside Madurai boundary
                {name: "Ramesh", lat: 9.9500, lng: 78.0900, online: false, plate: "TN 55 QR 2345"},
                {name: "Suresh", lat: 9.8700, lng: 78.1600, online: false, plate: "TN 56 ST 6789"}
            ];

            // Add driver markers
            drivers.forEach(driver => {
                const marker = new google.maps.Marker({
                    position: {lat: driver.lat, lng: driver.lng},
                    map: map,
                    title: `${driver.name} - ${driver.plate}`,
                    icon: {
                        url: driver.online ? "https://img.icons8.com/emoji/48/green-taxi.png" : "https://img.icons8.com/emoji/48/red-taxi.png",
                        scaledSize: new google.maps.Size(32, 32)
                    }
                });
                
                // Add info window for driver details
                const infoWindow = new google.maps.InfoWindow({
                    content: `<div><strong>${driver.name}</strong><br>${driver.plate}<br>Status: ${driver.online ? '<span style="color:green">Online</span>' : '<span style="color:red">Offline</span>'}</div>`
                });
                
                marker.addListener("mouseover", () => {
                    infoWindow.open(map, marker);
                });
                
                marker.addListener("mouseout", () => {
                    infoWindow.close();
                });
            });

            // Add current location marker
            const currentLocation = new google.maps.Marker({
                position: {lat: 9.9252, lng: 78.1198},
                map: map,
                title: "Your Location",
                icon: {
                    url: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png",
                    scaledSize: new google.maps.Size(40, 40)
                },
                animation: google.maps.Animation.BOUNCE
            });
        }
    </script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDQxxGSoe9-5ey_i_oaU2I_0b88Lq-ZpYs&callback=initMap" async defer></script>
</body>
</html>