@extends('admin.layout.adminmaster')
@section('style1')
<style>
 /* ===== TABLE BASE ===== */
.table {
    font-size: 13px;
    vertical-align: middle;
}

.table thead th {
    text-align: center;
    vertical-align: middle;
    white-space: nowrap;
}

/* ===== ROW HEIGHT & PADDING ===== */
.table td,
.table th {
    padding: 8px 10px;
}

/* ===== IMAGE COLUMN ===== */
.table td img {
    border: 1px solid #ccc;
    border-radius: 4px;
    padding: 2px;
    background: #fff;
}

/* ===== ACTION BUTTONS ===== */
.table td:last-child {
    white-space: nowrap;
    text-align: center;
}

.table td:last-child .btn {
    margin: 2px;
}

/* ===== DESCRIPTION COLUMN ===== */
.table td:nth-child(3) {
    max-width: 250px;
    white-space: normal;
    word-break: break-word;
}

/* ===== TYPES COLUMN ===== */
.table td:nth-child(4) {
    font-size: 12px;
    color: #555;
}

/* ===== PRICE COLUMN ===== */
.table td:nth-child(5) {
    font-weight: 600;
    text-align: right;
}

/* ===== HOVER EFFECT ===== */
.table tbody tr:hover {
    background-color: #f8f9fa;
}


/* ===== MOBILE RESPONSIVE ===== */
@media (max-width: 768px) {

    .table {
        font-size: 12px;
    }

    .table td img {
        width: 45px;
    }

    .table td:nth-child(3) {
        max-width: 140px;
    }
}

</style>
@endsection
@section('contentarea')
<div class="container">
    <h4>Add-On Management</h4>

    <a href="{{ route('admin.AddonManagement-create') }}"
       class="btn btn-primary mb-3">+ Add Add-On</a>

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Description</th>
                <th>Types</th>
                <th>Price</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($addons as $addon)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $addon->name }}</td>
                <td>{{ $addon->description ?? '-' }}</td>
                <td>{{ is_array($addon->type_ids) ? implode(', ', $addon->type_ids) : '' }}</td>
                <td>₹ {{ $addon->price }}</td>
                <td>
                    @if($addon->image)
                        <img src="{{ asset('storage/app/public/'.$addon->image) }}" width="60">
                    @endif
                </td>
                <td>
                    <a href="{{ route('admin.AddonManagement-edit',$addon) }}"
                       class="btn btn-sm btn-warning">Edit</a>

                    <form action="{{ route('admin.AddonManagement-destroy', $addon->id) }}"
      method="POST"
      onsubmit="return confirm('Delete this add-on?')">

    @csrf
    @method('DELETE')

    <button class="btn btn-danger btn-sm">
        Delete
    </button>
</form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
