@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h3>Edit Add-On</h3>

<form method="POST" action="{{ route('admin.AddonManagement-update', $addon->id) }}"enctype="multipart/form-data">
        @csrf
  @method('PUT')

<label>Name</label>
<input type="text"
       name="name"
       value="{{ old('name', $addon->name) }}"
       class="form-control mb-2">

<label>Description</label>
<textarea name="description"
          class="form-control mb-2">{{ old('description', $addon->description) }}</textarea>

 <label>Garment Types</label>
<select name="type_ids[]" class="form-control mb-2" multiple required>
    @foreach($types as $type)
        <option value="{{ $type }}"
            {{ in_array($type, $addon->type_ids ?? []) ? 'selected' : '' }}>
            {{ $type }}
        </option>
    @endforeach
</select>

<label>Price</label>
<input type="number"
       name="price"
       value="{{ old('price', $addon->price) }}"
       class="form-control mb-2">

<label>Image</label>
@if($addon->image)
    <div class="mb-2">
        <img src="{{ asset('storage/app/public/'.$addon->image) }}"
             width="80" class="rounded">
    </div>
@endif

<input type="file" name="image" class="form-control mb-3">

<button type="submit" class="btn btn-primary">Update</button>
<a href="{{ route('admin.AddonManagement-index') }}"
   class="btn btn-secondary">Cancel</a>

</form>
</div>
@endsection
