@extends('admin.layout.adminmaster')

@section('contentarea')
<div class="container">
    <h3>Add Add-On</h3>
<form method="POST" enctype="multipart/form-data" action="{{ route('admin.AddonManagement-store') }}">
@csrf

<label>Name</label>
<input type="text" name="name" class="form-control mb-2">

<label>Description</label>
<textarea name="description" class="form-control mb-2"></textarea>

<label>Garment Type</label>
<select name="type_ids[]" class="form-control mb-2" multiple required>
    @foreach($types as $type)
        <option value="{{ $type }}">{{ $type }}</option>
    @endforeach
</select>
<small class="text-muted">
    Hold Ctrl (Windows) / Cmd (Mac) to select multiple
</small>

<label>Price</label>
<input type="number" name="price" class="form-control mb-2">

<label>Image</label>
<input type="file" name="image" class="form-control mb-3">

<button class="btn btn-success">Save</button>
</form>
</div>
@endsection

