<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {

    public function up(): void
    {
        Schema::create('order_addons', function (Blueprint $table) {

            $table->id();

            $table->foreignId('order_id')
                  ->constrained()
                  ->cascadeOnDelete();

            $table->foreignId('profile_id')
                  ->constrained()
                  ->cascadeOnDelete();

            $table->foreignId('measurement_id')
                  ->constrained('order_measurements')
                  ->cascadeOnDelete();

            // 🔥 MULTIPLE ADD-ONS
            $table->json('addon_values');

            // 🔥 TOTAL ADD-ON AMOUNT
            $table->decimal('addon_amount', 10, 2)->default(0);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('order_addons');
    }
};

