<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('roles_has_permissions', function (Blueprint $table) {

            $table->bigIncrements('id');

            $table->unsignedBigInteger('role_id');
            $table->unsignedBigInteger('permission_id');

            $table->timestamps();

            $table->index(['role_id', 'permission_id']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('roles_has_permissions');
    }
};
