<?php
namespace App\Models;
use App\Models\OrderAddon;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $fillable = [
    'order_id',
    'profile_id',
    'garment_type',
    'reference_image',
    'notes',
    'unit_price',
    'discount',
    'quantity',
    'total_amount',
];
protected $casts = [
    'reference_image' => 'array',
];


   public function profile()
    {
        return $this->belongsTo(Profile::class);
    }
public function payment()
    {
        return $this->hasOne(Payment::class, 'order_item_id');
    }

    // ✅ Measurement/Profile relationship (if applicable)
 public function measurement()
{
    return $this->hasOne(OrderMeasurement::class, 'order_item_id');
}
public function order()
    {
        return $this->belongsTo(Order::class);
    }
    public function addons()
{
    return $this->hasOne(OrderAddon::class, 'order_item_id');
}
}
