<?php
namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class DriverManagement extends Authenticatable implements JWTSubject
{
    protected $table    = 'driver_management';
    protected $fillable = ['user_name', 'password'];
    protected $hidden   = ['password'];

    public function getJWTIdentifier()
    {
        return $this->getKey(); // ID
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
}
