<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Addon extends Model
{
    use HasFactory;

    protected $table = 'addons';

    protected $fillable = [
        'name',
        'description',
        'type_ids',
        'price',
        'image',
    ];

    /**
     * Cast JSON fields automatically
     */
    protected $casts = [
        'type_ids' => 'array',
        'price'    => 'float',
    ];

    /**
     * Accessor for image full URL
     */
    public function getImageUrlAttribute()
    {
        return $this->image
            ? asset('storage/' . $this->image)
            : asset('images/no-image.png');
    }

    /**
     * Check if addon is applicable for a garment
     */
    public function appliesTo(string $garmentType): bool
    {
        return in_array($garmentType, $this->type_ids ?? []);
    }
}
