<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UserManagementController extends Controller
{
    // List users
    public function index()
    {
        $users = User::orderBy('id', 'DESC')->get();
        return view('admin.user_management.list', compact('users'));
    }

    // Create Form
    public function create()
    {
        return view('admin.user_management.add');
    }

    // Store user
   public function store(Request $request)
{


    User::create([
        'name'        => $request->name,
        'email'       => $request->email,
        'phone'       => $request->phone,
        'role'        => $request->role,
        'permissions' => $request->permissions,
        'password'    => Hash::make($request->password),
        'status'      => 1,
    ]);

    return redirect()
        ->route('admin.UserManagement-index')
        ->with('success', 'User created successfully');
}

    // Edit user
    public function edit($id)
    {
        $user = User::findOrFail($id);
        return view('admin.user_management.edit', compact('user'));
    }

public function update(Request $request, $id)
{
    $request->validate([
        'name'        => 'required|string|max:255',
        'phone'       => 'required|digits:10',
        'role'        => 'required|in:admin,tailor,staff',
        'permissions' => 'required|array|min:1',
        'permissions.*' => 'string',
        'password'    => 'nullable|min:6|confirmed',
    ], [
        'permissions.required' => 'Please select at least one management access',
        'permissions.min'      => 'Please select at least one management access',
    ]);

    $user = User::findOrFail($id);

    $data = [
        'name'        => $request->name,
        'phone'       => $request->phone,
        'role'        => $request->role,
        'permissions' => $request->permissions, // ✅ UPDATED
    ];

    // 🔐 Update password only if entered
    if ($request->filled('password')) {
        $data['password'] = Hash::make($request->password);
    }

    $user->update($data);

    return redirect()
        ->route('admin.user_management.list')
        ->with('success', 'User updated successfully');
}


    // Delete user
    public function destroy($id)
    {
        User::findOrFail($id)->delete();
        return response()->json(['success' => true]);
    }

    // Activate/Deactivate
    public function toggleStatus($id)
    {
        $user         = User::findOrFail($id);
        $user->status = ! $user->status;
        $user->save();

        return response()->json(['status' => $user->status]);
    }
}
