<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;

class SettingManagementController extends Controller
{
    public function edit()
    {
        // Garment keys (store lowercase for DB safety)
        $garments = ['shirt', 'pant', 'blouse', 'chudithar'];

        // Age types (KEY => LABEL)
        $ages = [
            'below_5' => 'Below 5 Years',
            '5_to_16' => 'Above 5 to 16 Years',
            'adult'   => 'Adult',
        ];

        // Key as garment_age for easy access in blade
        $settings = Setting::all()
            ->keyBy(fn ($s) => $s->garment_type . '_' . $s->age_type);

        return view('admin.setting_management.edit', compact(
            'garments',
            'ages',
            'settings'
        ));
    }
public function update(Request $request)
{
    $allAges = ['below_5', '5_to_16', 'adult'];

    foreach ($request->prices as $garment => $agePrices) {

        foreach ($allAges as $ageType) {

            $price = $agePrices[$ageType] ?? 0;

            Setting::updateOrCreate(
                [
                    'garment_type' => $garment,
                    'age_type'     => $ageType,
                ],
                [
                    'price' => $price,
                ]
            );
        }
    }

    return back()->with('success', 'Settings updated successfully');
}


    public function getPrice(Request $request)
    {
        $price = Setting::where('garment_type', strtolower($request->garment))
            ->where('age_type', $request->age)
            ->value('price');

        return response()->json([
            'price' => $price ?? 0
        ]);
    }
}


