<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Payment;
use Illuminate\Http\Request;

class PaymentManagementController extends Controller
{
    public function create(Order $order)
    {
        return view('admin.payment_management.create', compact('order'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'order_id' => 'required|exists:orders,id',
            'amount' => 'required|numeric|min:1',
            'payment_mode' => 'required|in:cash,upi,card',
            'payment_date' => 'required|date',
        ]);

        Payment::create($request->all());

        return redirect()
            ->route('admin.OrderManagement-show', $request->order_id)
            ->with('success', 'Payment added successfully');
    }
}

