<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Payment;
use App\Models\Expense;
use App\Models\Order;
use Carbon\Carbon;


class DashboardController extends Controller
{
     public function index()
    {
            $today = Carbon::today();

    $data = [

        // 🟢 Today Orders (Created today)
        'todayOrders' => Order::whereDate('created_at', $today)->count(),

        // 💰 Today Received Amount (Advance paid today)
        'todayReceivedAmount' => Order::whereDate('created_at', $today)
            ->sum('advance_amount'),

        // 🚚 Today Delivered Orders
        'todayDeliveredOrders' => Order::whereDate('delivery_date', $today)
            ->where('status', 'delivered')
            ->count(),

        // 🔴 Overdue Orders
        'overdueOrders' => Order::whereDate('delivery_date', '<', $today)
            ->where('status', '!=', 'delivered')
            ->count(),

        // 🟡 Today Expected Orders
        'todayExpectedOrders' => Order::whereDate('delivery_date', $today)
            ->count(),

        // ⚠️ Undelivered Orders
        'undeliveredOrders' => Order::where('status', '!=', 'delivered')
            ->count(),
    ];

    return view('admin.dashboard_management.index', compact('data'));
}
}


