<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerManagementController extends Controller
{
    public function index(Request $request)
{
    $search = $request->query('search');

    $customers = Customer::when($search, function ($query, $search) {
            $query->where('name', 'like', "%{$search}%")
                  ->orWhere('phone', 'like', "%{$search}%");
        })
        ->orderBy('id', 'desc')
        ->paginate(10)
        ->withQueryString(); // keep search on pagination

    return view('admin.customer_management.list', compact(
        'customers',
        'search'
    ));
}

    public function create()
    {
        return view('admin.customer_management.add');
    }

public function store(Request $request)
{
    $request->validate([
        'name'  => 'required',
        'phone' => 'required',
        'email' => 'nullable',
    ]);

    Customer::create([
        'name'    => $request->name,
        'phone'   => $request->phone,
        'email'   => $request->email,
        'address' => $request->address,
        'is_vip'  => $request->has('is_vip'),
    ]);

    return redirect()
        ->route('admin.CustomerManagement-index')
        ->with('success', 'Customer added successfully');
}


    public function edit($id)
    {
         $customer = Customer::findOrFail($id);
        return view('admin.customer_management.edit', compact('customer'));
    }
    public function show($id)
    {
         $customer = Customer::findOrFail($id);
        return view('admin.customer_management.view', compact('customer'));
    }
    public function update(Request $request, $id)
{
    $customer = Customer::findOrFail($id);

    $request->validate([
        'name'  => 'required|string|max:255',

        'phone' => 'required|digits:10|unique:customers,phone,' . $customer->id,


        'email' => 'nullable|email|unique:customers,email,' . $customer->id,
    ]);

    $customer->update([
        'name'    => $request->name,
        'phone'   => $request->phone,
        'email'   => $request->email,
        'address' => $request->address,
        'is_vip'  => $request->has('is_vip') ? 1 : 0,
    ]);

    return redirect()
        ->route('admin.CustomerManagement-index')
        ->with('success', 'Customer updated successfully');
}


    public function destroy($id)
    {
        Customer::findOrFail($id)->delete();

        return redirect()->route('admin.CustomerManagement-index')
            ->with('success', 'Customer deleted successfully');
    }

   public function ajaxStore(Request $request)
   {
    $request->validate([
        'name'  => 'required|string|max:255',
        'phone' => 'required|string|max:20',
    ]);


    $customer = Customer::firstOrCreate(
        ['phone' => $request->phone],
        ['name'  => $request->name]
    );

    return response()->json([
        'success' => true,
        'data' => $customer
    ]);
}
}
