<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use App\Models\Addon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AddOnManagementController extends Controller
{
    public function index()
    {
        $addons = Addon::latest()->get();
        return view('admin.addon_management.index', compact('addons'));
    }

    public function create()
    {
        $types = ['Shirt','Pant','Blouse','Chudithar'];
        return view('admin.addon_management.create', compact('types'));
    }

    public function store(Request $request)
    {
        // dd($request);
        $data = $request->validate([
            'name' => 'required',
            'description' => 'nullable',
            'type_ids' => 'required|array',
            'price' => 'required|numeric',
            'image' => 'nullable|image'
        ]);

        if ($request->hasFile('image')) {
            $data['image'] = $request->image->store('addons', 'public');
        }
// dd($data);
        Addon::create($data);

        return redirect()->route('admin.AddonManagement-index')
            ->with('success','Add-On Created');
    }

    public function edit($id)
    {
        $addon = Addon::findOrFail($id);
        $types = ['Shirt','Pant','Blouse','Chudithar'];
        return view('admin.addon_management.edit', compact('addon','types'));
    }
 public function update(Request $request, $id)
{
    $addon = Addon::findOrFail($id);

    $data = $request->validate([
        'name'        => 'required|string|max:255',
        'description' => 'nullable|string',
        'price'       => 'required|numeric',
        'image'       => 'nullable|image',
        'type_ids'    => 'required|array',   // ✅ IMPORTANT
    ]);

    if ($request->hasFile('image')) {
        $data['image'] = $request->image->store('addons', 'public');
    }

    // ✅ THIS IS THE FIX
    $data['type_ids'] = $request->type_ids;

    $addon->update($data);

    return redirect()
        ->route('admin.AddonManagement-index')
        ->with('success', 'Add-On Updated Successfully');
}

    public function destroy($id)
{
    $addon = Addon::findOrFail($id);

    // delete image first
    if ($addon->image && Storage::disk('public')->exists($addon->image)) {
        Storage::disk('public')->delete($addon->image);
    }

    // delete database record
    $addon->delete();

    return redirect()
        ->route('admin.AddonManagement-index')
        ->with('success', 'Add-On Deleted Successfully');
}
}

