<?php
namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class OverAllReportExport implements FromView
{
    protected $records;
    protected $start_date;
    protected $end_date;
    protected $fb_report;

    public function __construct($records, $start_date, $end_date, $fb_report)
    {
        $this->records    = $records;
        $this->start_date = $start_date;
        $this->end_date   = $end_date;
        $this->fb_report  = $fb_report;
    }

    public function view(): View
    {
        return view('admin.exports.overall.overall_report_excel', [
            'data'       => $this->records,
            'start_date' => $this->start_date,
            'end_date'   => $this->end_date,
            'fb_report'  => $this->fb_report,
        ]);
    }

}
