<?php
namespace App\Exports;

use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class BuyerTransactionReport implements FromView
{
    protected $buyers;
    protected $start_date;
    protected $end_date;

    public function __construct($buyers, $start_date, $end_date)
    {
        $this->buyers     = $buyers;
        $this->start_date = $start_date;
        $this->end_date   = $end_date;
    }

    public function view(): View
    {
        return view('admin.exports.buyer.buyer_transactionreport_excel', [
            'data'       => $this->buyers,
            'start_date' => $this->start_date,
            'end_date'   => $this->end_date,
        ]);
    }

}
