<?php
namespace App\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class RideAcceptedEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $booking;
    public $driver;

    public function __construct($booking, $driver)
    {
        $this->booking = $booking;
        $this->driver  = $driver;
    }

    public function broadcastOn()
    {
        // Notify customer channel
        return new Channel('booking.' . $this->booking->id);
    }

    public function broadcastWith()
    {
        return [
            'driver_name'    => $this->driver->name,
            'driver_phone'   => $this->driver->phone,
            'vehicle_number' => $this->driver->vehicle_number,
            'status'         => 'accepted',
            'accepted_at'    => now()->toDateTimeString(),
        ];
    }
}
