<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="x-ua-compatible" content="ie=edge">
  <meta name="_token" content="<?php echo e(csrf_token()); ?>"/>

  <title>Shop CBD Brands | Admin</title>

  <!-- Font Awesome Icons -->
  <link rel="stylesheet" href="<?php echo e(asset('public/back/plugins/fontawesome-free/css/all.min.css')); ?>">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo e(asset('public/back/css/adminlte.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('public/back/css/custom.css')); ?>">
  <link rel="shortcut icon" href="<?php echo e(asset('public/front/images/favicon.ico')); ?>" type="image/x-icon">

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link href="<?php echo e(asset('public/plugin/toastr/toastr.css')); ?>" rel="stylesheet">

  <?php $__env->startSection('style'); ?>
        
  <?php echo $__env->yieldSection(); ?>
  
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

  <!-- Navbar -->
  <?php echo $__env->make('back.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- /.navbar -->


  <!-- Main Sidebar Container -->
  <?php echo $__env->make('back.layout.leftmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- Main Sidebar Container End-->
 
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    
    <?php $__env->startSection('breadcrum'); ?>
        
    <?php echo $__env->yieldSection(); ?>


    <?php $__env->startSection('content'); ?>
        
    <?php echo $__env->yieldSection(); ?>
   
  </div>
  <!-- /.content-wrapper -->

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
    <div class="p-3">
      <h5>Title</h5>
      <p>Sidebar content</p>
    </div>
  </aside>
  <!-- /.control-sidebar -->

  <!-- Main Footer -->
  <footer class="main-footer">
    <!-- To the right -->
    <div class="float-right d-none d-sm-inline">
    </div>
    <strong>Copyright © 2020 <a href="" target="_blank">ShopCBD</a> Brands All Right Reserved.</strong>
  </footer>
</div>
<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="<?php echo e(asset('public/back/plugins/jquery/jquery.min.js')); ?>"></script>

<?php $__env->startSection('script1'); ?>
        
<?php echo $__env->yieldSection(); ?>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('public/back/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

<!-- InputMask -->
<script src=".<?php echo e(asset('public/back/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('public/back/plugins/inputmask/min/jquery.inputmask.bundle.min.js')); ?>"></script>

<!-- AdminLTE App -->
<script src="<?php echo e(asset('public/back/js/adminlte.min.js')); ?>"></script>

<script src="<?php echo e(asset('public/plugin/toastr/toastr.min.js')); ?>"></script>
<?php $__env->startSection('script'); ?>
        
<?php echo $__env->yieldSection(); ?>


<script>
$(document).ready(function(){
  
  if($('.datemask').length > 0) 
  {
    $('.datemask').inputmask();
  }
  

  <?php if(session()->get('success')): ?>
  toastr.remove();
  toastr.success("<?php echo e(session()->get('success')); ?>");
  <?php endif; ?>

  <?php if(session()->get('info')): ?>
  toastr.remove();
  toastr.info("<?php echo e(session()->get('info')); ?>");
  <?php endif; ?>

  <?php if(session()->get('error')): ?>
  toastr.remove();
  toastr.error("<?php echo e(session()->get('error')); ?>");
  <?php endif; ?>


  <?php if(session()->get('warning')): ?>
  toastr.remove();
  toastr.warning("<?php echo e(session()->get('warning')); ?>");
  <?php endif; ?>

});
</script>
</body>
</html>
<?php /**PATH /home/bwjqfxmy/public_html/shopcbdbrands/resources/views/back/layout/master.blade.php ENDPATH**/ ?>