<?php $__env->startSection('breadcrum'); ?>
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Landing Training List</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
          <li class="breadcrumb-item"><a href="<?php echo e(route('landtraining-list')); ?>">Landing Training List</a></li>
          <li class="breadcrumb-item active">Add</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="content">
  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="<?php echo e(route('landtraining-list')); ?>" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>
  <br>
  
  <form method="POST" name="frmadd" id="frmadd" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php echo method_field('POST'); ?>
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary"> 
          <div class="card-body">
            <input type="text" name="crs_num_of_days" id="crs_num_of_days" value="1" style="display: none;" />
            <div class="row" id="dateallarea">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Start Date<span class="astrix">*</span></label>
                  <input type="text"  id="startdate" name="startdate"  data-inputmask-alias="datetime" data-inputmask-inputformat="dd-mm-yyyy" placeholder='dd-mm-yyyy' data-mask  class="form-control datemask eve_date" value="">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">End Date<span class="astrix">*</span></label>
                  <input type="text"  id="enddate" name="enddate"  data-inputmask-alias="datetime" data-inputmask-inputformat="dd-mm-yyyy" placeholder='dd-mm-yyyy' data-mask  class="form-control datemask eve_date" value="">
                </div>
              </div>
            </div>
            <div class="row">
              
              <div class="col-md-4">
                <div class="form-group">
                  <label for="inputName">Start Time<span class="astrix">*</span></label>
                  <input type="text"  id="starttime" name="starttime" class="form-control" value="" placeholder="hh:mm">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="inputName">End Time<span class="astrix">*</span></label>
                  <input type="text"  id="endtime" name="endtime" class="form-control" value="" placeholder="hh:mm">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="inputName">Fee<span class="astrix">*</span></label>
                  <input type="text"  id="crs_amount" name="crs_amount" class="form-control" value=""placeholder="Rs.100">
                </div>
              </div>
            </div>
            <div class="row">
            
            <div class="col-md-4">
                <div class="form-group">
                  <label for="inputName">Time Zone<span class="astrix">*</span></label>
                  <input type="text"  id="time_zone" name="time_zone" class="form-control" value="" placeholder="IST">
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label for="inputName">Class Mode</label>
                  <select class="form-control custom-select"  id="crs_class_mode" name="crs_class_mode"  >
                    <option value="1">Online</option>
                    <option value="2" selected="selected">Offline</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group" id="venue_area">
                  <label for="inputName">Venue</label>
                <select class="form-control custom-select"  id="crs_class_venue_id" name="crs_class_venue_id"  >
                    <option value=''>Select Venue</option>
                <?php $__currentLoopData = $venue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if($row->status=='2'): ?>   
                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->venue); ?> - <?php echo e($row->city); ?></option>
                 <?php endif; ?>      
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <label for="inputStatus">Trainer Name</label>
                  <select class="form-control custom-select" id="crs_class_instr_id"  name="crs_class_instr_id[]" multiple>
                    <option value=''>Select Trainer</option>
                <?php $__currentLoopData = $trainer_name; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->trainer_name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-12">
                <div class="form-group">
                  <label for="inputName">Registration Link</label>
                  <input type="text" id="elink" name="elink" class="form-control" value="">
                </div>
              </div>
            </div>
            <div class="form-group">
              <label for="inputDescription">Description</label>
              <textarea  id="description" name="description"  class="summernote form-control" rows="4"></textarea>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="customFile">Banner Image</label>
                  <div class="custom-file">
                    <input type="file" class="banner_img"  id="banner_img" name="banner_img" >
                    <label class="image" for="customFile"></label>
                  </div>
                </div>
                <?php if ($errors->has('banner_img')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('banner_img'); ?>
                <label class="error"><?php echo e($message); ?></label>
                <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?> </div>
                
                <div class="col-md-6">
            <div class="form-group">
                <label for="customFile">Trainer Image</label>
                <div class="custom-file">
                  <input type="file" class="trainer_img"  id="trainer_img" name="trainer_img" >
                  <label class="image" for="customFile"></label>
                </div>
              </div>
              <?php if ($errors->has('trainer_img')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('trainer_img'); ?>
                  <label class="error"><?php echo e($message); ?></label>
              <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
            </div>
            
            
              <div class="col-md-6">
                <div class="form-group">
                  <label for="customFile">Brouchare</label>
                  <div class="custom-file">
                    <input type="file" class="brouchare"  id="brouchare" name="brouchare" >
                    <label class="attachment-label" for="brouchare"></label>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputStatus">Status</label>
                  <select class="form-control custom-select"  id="status" name="status" >
                  <option value="1">Draft</option>
                  <option value="2" selected="selected">Publish</option>
                  </select>
                </div>
              </div>
            </div>
            <div class="form-group">
              <div class="col-12 text-center">
                <input type="submit" value="Save" name="submit" id="submit" class="btn btn-success ">
                <a href="<?php echo e(route('landtraining-list')); ?>" class="btn btn-secondary">Cancel</a> </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /.card-body -->
      <!-- /.card -->
    </div>
  </form>
  <p>&nbsp;</p>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<link href="<?php echo e(asset('public/plugin/summernote/summernote.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('public/plugin/date_picker_jq/jquery-ui.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('public/plugin/date_picker_jq/jquery.timepicker.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('public/plugin/date_picker_jq/jquery-ui.css')); ?>" rel="stylesheet">
<link href="<?php echo e(asset('public/plugin/select2/select2.min.css')); ?>" rel="stylesheet">
<style>
  .select2-container--default .select2-selection--single {
    height: 37px;
  }
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('public/plugin/summernote/summernote.js')); ?>"></script>
<script src="<?php echo e(asset('public/plugin/validate/jquery.validate.js')); ?>"></script>
<script src="<?php echo e(asset('public/plugin/validate/additional-methods.js')); ?>"></script>
<script src="<?php echo e(asset('public/plugin/date_picker_jq/jquery-ui.js')); ?>"></script>
<script src="<?php echo e(asset('public/plugin/date_picker_jq/jquery.timepicker.js')); ?>"></script>
<script src="<?php echo e(asset('public/plugin/select2/select2.min.js')); ?>"></script>
<script>
    $(document).ready(function() {
      $('#crs_class_venue_id').select2();
      $('#crs_class_instr_id').select2();

/*      $('#starttime').timepicker({
        'showDuration': true,
        'timeFormat': 'H:i'
      });

      $('#endtime').timepicker({
        'showDuration': true,
        'timeFormat': 'H:i'
      });


      $("#starttime").on('change', function(){
        var time = $(this).val();
        /*var getTime = time.split(":"); 
        var hours = parseInt(getTime[0])+2; 
        var newTime = hours+":"+getTime[1];
        console.log(time+"-"+newTime);
        //set time picker
        $("#endtime").timepicker('option',{'minTime': time});
    });*/

    function findNoDay()
    {
      var startDate = $('#startdate').val();
      var toDate = $('#enddate').val();
      if(startDate!="" && toDate!="" )
      {
        $diffday = 1 + calculateDayDiff(startDate,toDate)
      }else{
        $diffday = "";
      }
      $('#crs_num_of_days').val($diffday);
    }


      function changeFormat1($date="")
      {
        if($date!="")
        {
          $s_date = $date.slice(0,2);
          $s_month = $date.slice(3,5);
          $s_year = $date.slice(-4);
          
          $date = [$s_month,$s_date,$s_year].join('/');
        }
        return $date;
      }
        
      function calculateDayDiff(fromdate, todate)
      {
        var fromdate1 = changeFormat1(fromdate);
        var todate1 = changeFormat1(todate);

        var fromdate = new Date(fromdate1); 
        var todate = new Date(todate1); 
        var Difference_In_Time = todate.getTime() - fromdate.getTime(); 
        var Difference_In_Days = Difference_In_Time / (1000 * 3600 * 24); 
        return Difference_In_Days;
      }

      $('#crs_class_mode').on('change', function(){
        $selval = $(this).val();
        if($selval==1)
        {
          $('#venue_area').hide();
          $('#crs_class_venue_id').val('');
        }else{
          $('#venue_area').show();
          $('#crs_class_venue_id').val('');
        }
      });



      

      /*
      $("#id_reserve_time_start").on('change', function(){
    var time = $(this).val();
    var getTime = time.split(":"); //split time by colon
    var hours = parseInt(getTime[0])+2; //add two hours
    //set new time
    var newTime = hours+":"+getTime[1];
    //set time picker
    $("#id_reserve_time_end").timepicker('option',{'minTime': newTime});
})

      $('#onselectExample').timepicker();
      $('#onselectExample').on('changeTime', function() {
        $('#onselectTarget').text($(this).val());
      }); 
      
      */
      $( "#startdate" ).datepicker({
        dateFormat: 'dd-mm-yy',
        /*minDate: 1,*/
        changeMonth: true,
        changeYear: true,
        yearRange: "-10:+10",
        onSelect: function(dateText, inst){
          $("#enddate").datepicker("option","minDate",$("#startdate").datepicker("getDate"));
          findNoDay();
        }
      });

      $( "#enddate" ).datepicker({
        dateFormat: 'dd-mm-yy',
        /*minDate: 1,*/
        changeMonth: true,
        changeYear: true,
        yearRange: "-10:+10",
        onSelect: function(dateText, inst){
          //$("#enddate").datepicker("option","minDate",$("#startdate").datepicker("getDate"));
          findNoDay();
        }
      });


  $('.summernote').summernote({
    height: 200,
    popover: {
              image: [],
              link: [],
              air: []
            },
	callbacks: {
    onPaste: function (e) {
      var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('text/html');
	  if(bufferText)
	  {
      e.preventDefault();
      var div = $('<div />');
      div.append(bufferText);
      div.find('*').removeAttr('style');
      setTimeout(function () {
        document.execCommand('insertHtml', false, div.html());
      }, 10);
    }
	}
  }
  });






$('#frmadd').validate({
  rules:{
    startdate : {
        required:true
    },
    enddate : {
      required:true
    },
    crs_class_mode : {
      required:true
    },
 },

 messages:{
    title : {
      required:'Please enter  title'
    },
    title : {
      required:'Please enter  title'
    },
 },

 errorPlacement: function(error, element){
    if(element.attr("name") == "category[]") {
      error.appendTo( element.parent(".form-group") );
    } else {
      error.insertAfter(element);
    }
 }

})

});
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('back.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bwjqfxmy/public_html/shopcbdbrands/resources/views/back/landpage/training_add.blade.php ENDPATH**/ ?>