<?php



/*

|--------------------------------------------------------------------------

| Web Routes

|--------------------------------------------------------------------------

|

| Here is where you can register web routes for your application. These

| routes are loaded by the RouteServiceProvider within a group which

| contains the "web" middleware group. Now create something great!

|

*/
//Artisan::call('storage:link');
//Artisan::call('config:cache');
//Artisan::call('route:cache');


Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return "Cache is cleared";
});


Route::get('/config-cache', function() {
    Artisan::call('config:cache');
    return "config is cleared";
});


Route::get('/storage-link', function() {
    Artisan::call('storage:link');
    return "public set";
});


/*
Route::get('composercmd', function(){

    exec("composer require anhskohbo/no-captcha",$resultLines);
    
	foreach($resultLines as $resultLine){
         echo $resultLine."<br>";
     }

});*/


Auth::routes();



Route::post('/subscribe', 'FrontPageController@subscribenewsletter')->name('subscribenewsletter');

Route::get('/logout','Auth\LoginController@logout')->name('logout');

Route::get('/home', 'HomeController@index')->name('home');
Route::post('/reset_password_without_token', 'Auth\ResetPasswordController@validatePasswordRequest')->name('reset_password_without_token');

Route::post('/reset_password_with_token', 'Auth\ResetPasswordController@resetPassword');
Route::get('/training-detail/{eventId}', 'FrontPageController@eventbritedetail')->name('eventbritedetail')->where('eventId', '[0-9]+');


Route::match(['get', 'post'], '/getcourses/{id}', 'FrontPageController@getsafecourses');
Route::match(['get', 'post'], '/newslist/', 'FrontPageController@newslist');

Route::group(['prefix' => 'administrator', 'middleware' => ['auth']], function () {



    Route::get('/cms-list', 'Admin\AdminController@index')->name('cms-list');

    



    Route::get('/news-list', 'Admin\NewsController@index')->name('news-list');

    Route::get('/news-add', 'Admin\NewsController@create')->name('news-add');

    Route::post('/news-add', 'Admin\NewsController@store')->name('news-add');

    Route::PUT('/news-statuschange', 'Admin\NewsController@updateStatus')->name('news-statuschange');

    Route::DELETE('/news/{newsId}', 'Admin\NewsController@destroy')->name('news-destroy')->where('newsId', '[0-9]+');

    Route::PUT('/news/{newsId}', 'Admin\NewsController@update')->name('news-update')->where('newsId', '[0-9]+');

    Route::get('/news/{newsId}/edit', 'Admin\NewsController@edit')->name('news-edit')->where('newsId', '[0-9]+');

    Route::get('/news/{newsId}/view', 'Admin\NewsController@show')->name('news-view')->where('newsId', '[0-9]+');

    Route::get('/invoice_download/{filename}', 'Admin\RegistrationController@invoice_download')->name('invoice_download');
    Route::post('/invoice_email', 'Admin\RegistrationController@invoice_email')->name('invoice_email');




  




    //User Activation
   
    Route::get('/user-list', 'Admin\UserActivateController@index')->name('user-list');
    Route::PUT('/user-statuschange', 'Admin\UserActivateController@updateStatus')->name('user-statuschange');








    Route::get('/categorytrack-list', 'Admin\CategorytrackController@index')->name('categorytrack-list');
    Route::get('/categorytrack-add', 'Admin\CategorytrackController@create')->name('categorytrack-add');
    Route::post('/categorytrack-add', 'Admin\CategorytrackController@store')->name('categorytrack-add');
    Route::PUT('/categorytrack-statuschange', 'Admin\CategorytrackController@updateStatus')->name('categorytrack-statuschange');
    Route::DELETE('/categorytrack/{categoryId}', 'Admin\CategorytrackController@destroy')->name('categorytrack-destroy')->where('categoryId', '[0-9]+');
   Route::PUT('/categorytrack/{categoryId}', 'Admin\CategorytrackController@update')->name('categorytrack-update')->where('categoryId', '[0-9]+');
   Route::get('/categorytrack/{categoryId}/edit', 'Admin\CategorytrackController@edit')->name('categorytrack-edit')->where('categoryId', '[0-9]+');
  Route::get('/categorytrack/{categoryId}/view', 'Admin\CategorytrackController@show')->name('categorytrack-view')->where('categoryId', '[0-9]+');
  Route::post('/getcategorystatusbycat', 'Admin\CategorytrackController@getcategorystatusbycat')->name('getcategorystatusbycat');
	
	

Route::post('/getcoursebycatdomain', 'Admin\SubCategoryController@getcoursebycatdomain')->name('getcoursebycatdomain');
Route::post('/getcoursebyid', 'Admin\SubCategoryController@getcoursebyid')->name('getcoursebyid');










    



    Route::get('/user-management-list', 'Admin\UserManagementController@index')->name('user-management-list');
    Route::PUT('/usermgmt-statuschange', 'Admin\UserManagementController@updateStatus')->name('usermgmt-statuschange');

    Route::get('/registrations-list/{eventId}', 'Admin\RegistrationController@index')->name('registrations-list')->where('eventId', '[0-9]+');

    

	
	

   



    Route::PUT('/settings/{Id}', 'Admin\SettingsController@update')->name('settings-update')->where('Id', '[0-9]+');

    Route::get('/settings/settings', 'Admin\SettingsController@edit')->name('settings');





   



    Route::PUT('/aboutus/{Id}', 'Admin\AboutusController@update')->name('aboutus-update')->where('Id', '[0-9]+');

    Route::get('/aboutus/aboutus', 'Admin\AboutusController@edit')->name('aboutus');



   
//category list shopcbd

    Route::get('/subcategory-list', 'Admin\SubCategoryController@index')->name('subcategory-list');

    Route::get('/subcategory-add', 'Admin\SubCategoryController@create')->name('subcategory-add');

    Route::post('/subcategory-add', 'Admin\SubCategoryController@store')->name('subcategory-add');

    Route::PUT('/subcategory-statuschange', 'Admin\SubCategoryController@updateStatus')->name('subcategory-statuschange');

    Route::DELETE('/subcategory/{subcategoryId}', 'Admin\SubCategoryController@destroy')->name('subcategory-destroy')->where('subcategoryId', '[0-9]+');

    Route::PUT('/subcategory/{subcategoryId}', 'Admin\SubCategoryController@update')->name('subcategory-update')->where('subcategoryId', '[0-9]+');

    Route::get('/subcategory/{subcategoryId}/edit', 'Admin\SubCategoryController@edit')->name('subcategory-edit')->where('subcategoryId', '[0-9]+');

    Route::get('/subcategory/{subcategoryId}/view', 'Admin\SubCategoryController@show')->name('subcategory-view')->where('subcategoryId', '[0-9]+');
	
	
	//ADmin
	
	Route::get('/dashboard', 'Admin\AdminController@index')->name('admin.dashboard');

	//Route::get('/', 'Admin\AdminController@index');
	
//Blog management

    Route::get('/blog-list', 'Admin\BlogController@index')->name('blog-list');

    Route::get('/blog-add', 'Admin\BlogController@create')->name('blog-add');

    Route::post('/blog-add', 'Admin\BlogController@store')->name('blog-add');

    Route::PUT('/blog-statuschange', 'Admin\BlogController@updateStatus')->name('blog-statuschange');

    Route::DELETE('/blog/{blogId}', 'Admin\BlogController@destroy')->name('blog-destroy')->where('blogId', '[0-9]+');

    Route::PUT('/blog/{blogId}', 'Admin\BlogController@update')->name('blog-update')->where('blogId', '[0-9]+');

    Route::get('/blog/{blogId}/edit', 'Admin\BlogController@edit')->name('blog-edit')->where('blogId', '[0-9]+');

    Route::get('/blog/{blogId}/view', 'Admin\BlogController@show')->name('blog-view')->where('blogId', '[0-9]+');

//product management
    Route::get('/product-list', 'Admin\ProductController@index')->name('product-list');

    Route::get('/product-add', 'Admin\ProductController@create')->name('product-add');

    Route::post('/product-add', 'Admin\ProductController@store')->name('product-add');

    Route::PUT('/product-statuschange', 'Admin\ProductController@updateStatus')->name('product-statuschange');

    Route::DELETE('/product/{productId}', 'Admin\ProductController@destroy')->name('product-destroy')->where('productId', '[0-9]+');

    Route::PUT('/product/{productId}', 'Admin\ProductController@update')->name('product-update')->where('productId', '[0-9]+');

    Route::get('/product/{productId}/edit', 'Admin\ProductController@edit')->name('product-edit')->where('productId', '[0-9]+');

    Route::get('/product/{productId}/view', 'Admin\ProductController@show')->name('product-view')->where('productId', '[0-9]+');
	
	 Route::POST('/search', 'Admin\ProductController@search')->name('search');
     Route::get('/search', 'Admin\ProductController@search')->name('search');
	
   




    


  

      
	  
	  //Review MAnangement 
    Route::PUT('/review-rstatuschange', 'Admin\ReviewController@rstatus')->name('review-statuschange');
    
	 Route::get('/review-list', 'Admin\ReviewController@index')->name('review-list');

    Route::get('/review-add', 'Admin\ReviewController@create')->name('review-add');

    Route::post('/review-add', 'Admin\ReviewController@store')->name('review-add');

    Route::PUT('/review-statuschange', 'Admin\ReviewController@updateStatus')->name('review-status');

    Route::DELETE('/review/{reviewId}', 'Admin\ReviewController@destroy')->name('review-destroy')->where('reviewId', '[0-9]+');

    Route::PUT('/review/{reviewId}', 'Admin\ReviewController@update')->name('review-update')->where('reviewId', '[0-9]+');

    Route::get('/review/{reviewId}/edit', 'Admin\ReviewController@edit')->name('review-edit')->where('reviewId', '[0-9]+');

    Route::get('/review/{reviewId}/view', 'Admin\ReviewController@show')->name('review-view')->where('reviewId', '[0-9]+');

   //SubscribeManagement

  Route::get('/subscribe-list', 'Admin\SubscribeController@index')->name('subscribe-list');
  Route::DELETE('/subscribe/{subscribeId}', 'Admin\SubscribeController@destroy')->name('subscribe-destroy')->where('subscribeId', '[0-9]+');
  Route::get('/subscribe/{subscribeId}/view', 'Admin\SubscribeController@show')->name('subscribe-view')->where('subscribeId', '[0-9]+');
  
  
 //CBD recipe Management
 
  Route::get('/cbdrecipe-list', 'Admin\CbdrecipeController@index')->name('cbdrecipe-list');
  Route::get('/cbdrecipe-add', 'Admin\CbdrecipeController@create')->name('cbdrecipe-add');
   Route::post('/cbdrecipe-store', 'Admin\CbdrecipeController@store')->name('cbdrecipe-store');
  
  Route::PUT('/cbdrecipe-statuschange', 'Admin\CbdrecipeController@updateStatus')->name('cbdrecipe-statuschange');

    Route::DELETE('/cbdrecipe/{cbdrecipeId}', 'Admin\CbdrecipeController@destroy')->name('cbdrecipe-destroy')->where('cbdrecipeId', '[0-9]+');

    Route::PUT('/cbdrecipe/{cbdrecipeId}', 'Admin\CbdrecipeController@update')->name('cbdrecipe-update')->where('cbdrecipeId', '[0-9]+');

    Route::get('/cbdrecipe/{cbdrecipeId}/edit', 'Admin\CbdrecipeController@edit')->name('cbdrecipe-edit')->where('cbdrecipeId', '[0-9]+');

    Route::get('/cbdrecipe/{cbdrecipeId}/view', 'Admin\CbdrecipeController@show')->name('cbdrecipe-view')->where('cbdrecipeId', '[0-9]+');
	
	
	//Brand Management
	
	 Route::get('/brand-list', 'Admin\BrandController@index')->name('brand-list');
     Route::get('/brand-add', 'Admin\BrandController@create')->name('brand-add');
     Route::post('/brand-store', 'Admin\BrandController@store')->name('brand-store');
     Route::PUT('/brand-statuschange', 'Admin\BrandController@updateStatus')->name('brand-statuschange');
     Route::DELETE('/brand/{brandId}', 'Admin\BrandController@destroy')->name('brand-destroy')->where('brandId', '[0-9]+');
     Route::PUT('/brand/{brandId}', 'Admin\BrandController@update')->name('brand-update')->where('brandId', '[0-9]+');
     Route::get('/brand/{brandId}/edit', 'Admin\BrandController@edit')->name('brand-edit')->where('brandId', '[0-9]+');
     Route::get('/brand/{brandId}/view', 'Admin\BrandController@show')->name('brand-view')->where('brandId', '[0-9]+');
	
	
		//PrivacyNote Management
	
	 Route::get('/privacy-list', 'Admin\PrivacyController@index')->name('privacy-list');
     Route::get('/privacy-add', 'Admin\PrivacyController@create')->name('privacy-add');
     Route::post('/privacy-store', 'Admin\PrivacyController@store')->name('privacy-store');
     Route::PUT('/privacy-statuschange', 'Admin\PrivacyController@updateStatus')->name('privacy-statuschange');
     Route::DELETE('/privacy/{privacyId}', 'Admin\PrivacyController@destroy')->name('privacy-destroy')->where('privacyId', '[0-9]+');
     Route::PUT('/privacy/{privacyId}', 'Admin\PrivacyController@update')->name('privacy-update')->where('privacyId', '[0-9]+');
     Route::get('/privacy/{privacyId}/edit', 'Admin\PrivacyController@edit')->name('privacy-edit')->where('privacyId', '[0-9]+');
     Route::get('/privacy/{privacyId}/view', 'Admin\PrivacyController@show')->name('privacy-view')->where('privacyId', '[0-9]+');
	 
	 
	 
	//Contact Management
    Route::get('/contact-list', 'Admin\ContactController@index')->name('contact-list');
    Route::DELETE('/contact/{id}', 'Admin\ContactController@destroy')->name('contact-destroy')->where('id', '[0-9]+');
    Route::get('/contact/{contactId}', 'Admin\ContactController@show')->name('contact-view');


    //Menu management
    Route::get('/menu-list', 'Admin\MenuController@index')->name('menu-list');
    Route::get('/menu-add', 'Admin\MenuController@create')->name('menu-add');
    Route::post('/menu-add', 'Admin\MenuController@store')->name('menu-add');
    Route::PUT('/menu-statuschange', 'Admin\MenuController@updateStatus')->name('menu-statuschange');
    Route::DELETE('/menu/{menuId}', 'Admin\MenuController@destroy')->name('menu-destroy')->where('menuId', '[0-9]+');
    Route::PUT('/menu/{menuId}', 'Admin\MenuController@update')->name('menu-update')->where('menuId', '[0-9]+');
    Route::get('/menu/{menuId}/edit', 'Admin\MenuController@edit')->name('menu-edit')->where('menuId', '[0-9]+');
   Route::get('/menu/{menuId}/view', 'Admin\MenuController@show')->name('menu-view')->where('menuId', '[0-9]+');

    
	



    Route::get('/homepage-list', 'Admin\homePageControllerCmn@index')->name('homepage-list');

    Route::PUT('/homepage-statuschange', 'Admin\MenuController@updateStatus')->name('homepage-statuschange');

   Route::get('/homepage1-list', 'Admin\homePageController1@index')->name('homepage1-list');

    Route::get('/homepage1-add', 'Admin\homePageController1@create')->name('homepage1-add');

    Route::post('/homepage1-add', 'Admin\homePageController1@store')->name('homepage1-add');

    Route::PUT('/homepage1-statuschange', 'Admin\homePageController1@updateStatus')->name('homepage1-statuschange');

    Route::get('/homepage1/{menuId}/edit', 'Admin\homePageController1@edit')->name('homepage1-edit')->where('menuId', '[0-9]+');

    Route::get('/homepage1/{menuId}/view', 'Admin\homePageController1@show')->name('homepage1-view')->where('menuId', '[0-9]+');

    Route::PUT('/homepage1/{menuId}', 'Admin\homePageController1@update')->name('homepage1-update')->where('menuId', '[0-9]+');

    Route::DELETE('/homepage1/{menuId}', 'Admin\homePageController1@destroy')->name('homepage1-destroy')->where('menuId', '[0-9]+');

	

	

	

	Route::get('/profile-edit', 'Admin\AdminProfileController@edit')->name('profile-edit');
	Route::post('/profile-edit', 'Admin\AdminProfileController@update')->name('profile-update');
	Route::get('/change-password', 'Admin\AdminProfileController@changepassword')->name('change-password');
	Route::post('/change-password', 'Admin\AdminProfileController@updatepassword')->name('update-password');
	



});

Route::get('/safedatatable', 'FrontPageController@safedatatable')->name('safedatatable');
Route::get('/scrumalliancedatatable', 'FrontPageController@scrumalliancedatatable')->name('scrumalliancedatatable');
Route::get('/blockchaindatatable', 'FrontPageController@blockchaindatatable')->name('blockchaindatatable');

/*Route::get('/signup', 'FrontPageController@registeruser')->name('signup');*/
Route::get('/signup',function(){  return redirect('home'); })->name('signup');
Route::post('/newregister', 'FrontPageController@register')->name('newregister');
Route::post('/contactformsave', 'FrontPageController@contactformsave')->name('contactformsave');
Route::post('/converformsave', 'FrontPageController@converformsave')->name('converformsave');
Route::post('/converformsavetest', 'FrontPageController@converformsavetest')->name('converformsavetest');

Route::post('/privateclasssave', 'FrontPageController@privateclasssave')->name('privateclasssave');

Route::get('/notify', 'FrontPageController@notifypaypal')->name('notify');
Route::get('/cancel', 'FrontPageController@cancelpaypal')->name('cancel');
Route::get('/return', 'FrontPageController@returnpaypal')->name('return');

//unique pages

Route::get('/contact-us', 'FrontPageController@contactUs');
Route::get('/blog', 'FrontPageController@blog');
Route::get('/blog/{slug}', 'FrontPageController@blogDetail')->name('blog-detail');

Route::get('/partners', 'FrontPageController@partners');

Route::get('/privacynotes', 'FrontPageController@privacynotes');


Route::get('/cbdrecipe', 'FrontPageController@cbdrecipe');
Route::get('/listblog/{slug}/{id}', 'FrontPageController@listblog')->name('listblog');
Route::post('/reviewsubmit', 'FrontPageController@Reviewsubmit');
Route::post('/contactsubmit', 'FrontPageController@contactformsave');
Route::post('/subscribesubmit', 'FrontPageController@subscribesubmit')->name('subscribesubmit');

Route::post('/proname', 'FrontPageController@proname')->name('proname');
//product list frontend
//Route::get('/product-detail/{id}/{catname}/{cid}', 'FrontPageController@detail')->name('product-detail');
//Route::get('/product-detail/{id}/{cid}', 'FrontPageController@detail')->name('product-detail');
Route::get('/product-detail/{slug}/{productslug}', 'FrontPageController@detail')->name('product-detail');

//Route::get('/productlist', 'FrontPageController@product')->name('product');
Route::get('/productlist/{id}', 'FrontPageController@product')->name('product');

Route::get('/productlist/{productname}/{id}', 'FrontPageController@product')->name('product');

Route::get('/productlist/{productname}/{id}/{svalue}', 'FrontPageController@product')->name('product');
Route::get('/productlist/{productname]/{svalue}', 'FrontPageController@product')->name('product');

// Route::get('/productlist/{id}/{svalue}', 'FrontPageController@product')->name('product');
 



Route::get('/news/{slug}', 'FrontPageController@newsDetail')->name('news-detail');

Route::get('/wiki/{slug}', 'FrontPageController@wikiDetail')->name('wiki-detail');

Route::get('/article/{slug}', 'FrontPageController@articleDetail')->name('article-detail');

Route::get('/service/{slug}', 'FrontPageController@serviceDetail')->name('service-detail');



Route::get('/incompany_training', 'FrontPageController@incompany_training');

Route::get('/trainers', 'FrontPageController@trainers');

Route::get('/vision', 'FrontPageController@vision');

Route::get('/vacancies', 'FrontPageController@vacancies');
Route::get('/safe', 'FrontPageController@safe');
Route::get('/safe', 'FrontPageController@safe');
Route::get('/blockchain', 'FrontPageController@blockchain');
Route::get('/eventdetail/{eventid}', 'FrontPageController@eventdetail')->name('eventdetail')->where('eventid', '[0-9_]+');
Route::get('/neweventdetail/{eventid}', 'FrontPageController@neweventdetail')->name('neweventdetail')->where('eventid', '[0-9_]+');

Route::get('{catname}/{eventslug}/courses/certification-training/online-class/{eventid}', 'FrontPageController@eventdetail_newurl');
Route::get('{catname}/{eventslug}/courses/certification-training/testonline-class/{eventid}', 'FrontPageController@testeventdetail_newurl');

Route::get('/register-paypal/{eventid}', 'FrontPageController@registerpaypal')->name('register-paypal')->where('eventid', '[0-9]+');
Route::post('/paypal_register', 'FrontPageController@paypalregister')->name('paypal_register');
Route::post('/taxcalc', 'FrontPageController@taxcalc')->name('taxcalc');

Route::post('/sendPersonalEmail', 'FrontPageController@sendPersonalEmail');





Route::get('/home', 'FrontPageController@index')->name('home');

Route::get('/', 'FrontPageController@index');


//page slug
Route::get('/{slug}', 'FrontPageController@page');