@extends('back.layout.master')

@section('breadcrum')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Product management</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item active">Product management</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>

{{--  @if(session()->get('success'))

@endif  --}}

@endsection
@section('content')

<section class="content">

<div class="row">
<div class="col-md-6">
<form method="POST" action="{{route('search')}}" enctype="multipart/form-data">
@csrf
  @method('POST')
               <div class="input-group">
               
            <input type="search"  name="search" value="{{request()->input('search')}}" class="form-control"/>
				
		<input type="submit" class="btn btn-primary" value="Search" />
     </div>
        </form>
        </div>
<div class="col-md-6" style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block">


         <a href="{{route('product-add')}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm">+ Add</a>
  </div>
  </div>
  <br>
  <!-- Default box -->
  <div class="card">
    {{-- <div class="card-header">
      <h3 class="card-title">Projects</h3>
      <div class="card-tools">
        <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
      </div>
    </div> --}}
    <div class="card-body p-0">
      <table class="table table-striped projects" id="listTable">
        <thead>
          <tr>
            <th style="width: 20%"> S.No </th>
           <!-- <th>Image</th>-->
            <th style="width: 40%"> Title </th>            
            <th style="width: 20%"> Date </th>
            <th style="width: 30%" class="text-center"> Status </th>
          </tr>
        </thead>
        <tbody>
        
        
        
        
       @php( $cnt = ((($productList->currentPage()-1) * $productList->perPage()) + 1))

          @if(!$productList->isEmpty())
            @foreach ($productList as $row)
              <tr id="currentRow_{{$row->id}}" class="resultRow">
                <td> {{$cnt++}}</td>
              
                <td><a> {{ucfirst($row->title)}}</a></td>                
                
                <td> @if($row->product_date){{date('j F, Y', strtotime($row->product_date))}}@else -  @endif</td>
                <td><!--<span class="badge badge-success">Success</span>-->
                  @if($row->status==2)
                  <a data-id="{{$row->id}}" data-typ="1" id="statuschange_{{$row->id}}" class="btn btn-success btn-sm changeStatus" href="#" title="Click to disable"> <i class="fa fa-check"> </i> </a> 
                  @elseif($row->status==1)
                  <a data-id="{{$row->id}}" data-typ="2"  id="statuschange_{{$row->id}}"  class="btn btn-danger btn-sm changeStatus" href="#" title="Click to enable">&nbsp;<i class="fa fa-times"> </i>&nbsp;</a> 
                  @endif
                  <a class="btn btn-primary btn-sm" href="{{route('product-view',$row->id)}}?page={{$productList->currentPage()}}" title="View"> <i class="fas fa-eye"> </i> </a> 
                  <a class="btn btn-info btn-sm" href="{{route('product-edit',$row->id)}}?page={{$productList->currentPage()}}" title="Edit"> <i class="fas fa-pencil-alt"> </i> </a> 
                  <a  data-id="{{$row->id}}"  class="btn btn-danger btn-sm deleteRow" href="#" title="Delete"> <i class="fas fa-trash"> </i>  </a> </td>
              </tr> 
            @endforeach
          @else
          <tr>
            <td colspan='6' style="text-align:center">No Records Found</td>
          </tr>
          @endif
        
        
        
        </tbody>
        </table>
         <div style="width:auto; padding:10px;float:right; text-align:right; margin:0px auto;">
          {!!$productList->appends(request()->except('page','_token'))->render() !!}
      </div>
      
       
      
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</section>
@endsection

@section('script')
    <script>
        $(document).ready(function() {

          $('table').on('click', '.changeStatus', function(e){
            e.preventDefault();
            $chId = $(this).data('id');
            $chTyp = $(this).data('typ');
            if($chTyp==1)
            {
              $cnfrmMsg = "Are you sure to Disable this record.";
              $removeClass = "btn-success";
              $addClass = "btn-danger";
              $changeicon = '&nbsp;<i class="fa fa-times"> </i>&nbsp;';
              $tochTyp=2;

            }else if($chTyp==2)
            {
              $cnfrmMsg = "Are you sure to Enable this record.";
              $removeClass = "btn-danger";
              $addClass = "btn-success";
              $changeicon = '<i class="fa fa-check"> </i>';
              $tochTyp=1;
            }

            var k = confirm($cnfrmMsg);

            if(k==true)
            {
              $.ajax({
                url : "{{route('product-statuschange')}}",
                method: "PUT",
                data : { chid : $chId, chtyp : $chTyp, _token: '{{csrf_token()}}' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==200)
                  {
                    toastr.success("Status Updated Successfully");
                    $('#statuschange_'+$chId).removeClass($removeClass).addClass($addClass);
                    $('#statuschange_'+$chId).html($changeicon);
                    $('#statuschange_'+$chId).data('typ',$tochTyp);

                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });
            }

          });


 $('table').on('click', '.deleteRow', function(e){
            e.preventDefault();
            $chId = $(this).data('id');

            var k = confirm("Are you sure to Delete this record.");

            if(k==true)
            {
              $.ajax({
                url : "product/"+ $chId ,
                method: "DELETE",
                data : { _token: '{{csrf_token()}}' },
                error: function(data){
                  toastr.error("Error Occured. Please Try Again Later.");
                },
                success : function(result){
                  result = JSON.stringify(result)
                  result = JSON.parse(result);
                  if(result.status==200)
                  {
                    toastr.success("Deleted Successfully");
                    $('#currentRow_'+$chId).remove();
                    $rowlength = $('#listTable tbody tr').length;
                    
                    if($rowlength == '0')
                    {
                      $('#listTable tbody').html('<tr><td colspan="5" style="text-align:center">No Records Found</td></tr>');
                    }

                  }else{
                    toastr.error("Error Occured. Please Try Again Later.");
                  }
                }
                
              });
            }

          });

        });
    </script>
@endsection