@extends('back.layout.master')

@section('breadcrum')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{$catRow->name}}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item"><a href="{{route('menu-list')}}">{{$catRow->name}}</a></li>
          <li class="breadcrumb-item active">Edit</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>
@endsection



@section('content')
<section class="content">
  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{route('menu-list')}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>
  <br>


{{-- @if($errors->any())
<div class="alert alert-danger">
  <ul>
      @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
      @endforeach
  </ul>
</div><br />
@endif --}}




  <form method="POST" name="newsadd" id="newsadd" enctype="multipart/form-data" action="{{route('menu-update',$currentRecord->id)}}?page={{$page}}">
  @csrf
  @method('PUT')
  <div class="row">
    <div class="col-md-12">
      <div class="card card-primary"> {{--
        <div class="card-header">
          <h3 class="card-title">General</h3>
          <div class="card-tools">
            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
          </div>
        </div>
        --}}
        <div class="card-body">
         
          <div class="form-group">
            <label for="inputName">Title</label>
            <input type="text" id="title" name="title" class="form-control" value="{{$currentRecord->title}}">
          </div>
          <div class="form-group">
            <label for="inputDescription">Description</label>
            <textarea  id="description" name="description"  class="summernote form-control" rows="4">{{$currentRecord->description}}</textarea>
          </div>
          <!--<div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="customFile">Image</label>
                <div class="custom-file">
                  <input type="file" class="image"  id="image1" name="image1" >
                  <label class="image" for="customFile"></label>
                </div>
                @if($currentRecord->img1 != '')
                <img src="{{asset('public/storage/pages/'.$currentRecord->img1 )}}" style="max-width:100px; max-height:100px;"  />
                @endif
              </div>
              @error('image')
                  <label class="error">{{ $message }}</label>
              @enderror
            </div>
              
            <div class="col-md-6">
              <div class="form-group">
                <label for="customFile">Attachment</label>
                <div class="custom-file">
                  <input type="file" class="attachment"  id="attachment1" name="attachment1" >
                  <label class="attachment-label" for="attachment"></label>
                </div>
                @if($currentRecord->attachment1 != '')
                <a href="{{asset('public/storage/pages/'.$currentRecord->attachment1 )}}" target="_blank"/>Click to view</a>
                @endif
              </div>
            </div>
          </div>-->
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="inputName">Link</label>
                <input type="text"  id="link" name="link" class="form-control" value="{{$currentRecord->link}}">
              </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                  <label for="inputStatus">Status</label>
                  <select class="form-control custom-select"  id="status" name="status" >
                    <option value="1" @if($currentRecord->status == '1') selected="selected" @endif>Disable</option>
                    <option value="2" @if($currentRecord->status == '2') selected="selected" @endif>Enable</option>
                  </select>
                </div>
              </div>
          </div>
         
         

          <div class="form-group">
            <label for="inputName">Meta Title</label>
            <input type="text" id="meta_title" name="meta_title" class="form-control" value="{{$currentRecord->meta_title}}">
          </div>
          <div class="form-group">
            <label for="inputDescription">Meta Description</label>
            <textarea  id="meta_description" name="meta_description"  class="form-control" rows="4">{{$currentRecord->meta_description}}</textarea>
          </div>
          <div class="form-group">
            <label for="inputDescription">Meta Keywords</label>
            <textarea  id="meta_keywords" name="meta_keywords"  class="form-control" rows="2">{{$currentRecord->meta_keywords}}</textarea>
          </div>



        </div>
        <!-- /.card-body -->
        <div class="form-group">
          <div class="col-12 text-center">
            <input type="submit" value="Save" name="submit" id="submit" class="btn btn-success ">
            <a href="{{url()->previous()}}" class="btn btn-secondary">Cancel</a> </div>
        </div>
      </div>
      <!-- /.card -->
    </div>
  </div>
</form>
  <p>&nbsp;</p>
</section>
@endsection

@section('style')
<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/date_picker_jq/jquery-ui.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/date_picker_jq/select2.min.css') }}" rel="stylesheet">

@endsection


@section('script')
<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>
<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>
<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>
<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>
<script src="{{asset('public/plugin/date_picker_jq/jquery-ui.js') }}"></script>

<script>
    $(document).ready(function() {


      $( "#date" ).datepicker({
        dateFormat: 'mm-dd-yy',
        /*minDate: 1,*/
        changeMonth: true,
        changeYear: true,
        yearRange: "-10:+10",
        onSelect: function(dateText, inst){
        //mYt("#cal_start_date_2").datepicker("option","minDate",mYt("#cal_start_date_1").datepicker("getDate"));
        }
      });


  $('.summernote').summernote({
    height: 200,
    popover: {
              image: [],
              link: [],
              air: []
            },
	callbacks: {
    onPaste: function (e) {
      var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('text/html');
	  if(bufferText)
	  {
      e.preventDefault();
      var div = $('<div />');
      div.append(bufferText);
      div.find('*').removeAttr('style');
      setTimeout(function () {
        document.execCommand('insertHtml', false, div.html());
      }, 10);
    }
	}
  }
  });



  $("#category").select2({
    tags: true,
    tokenSeparators: [',']
})

$('#category').show();


$('#newsadd').validate({
  rules:{
    'category[]' : {
      required:true
    },

    title : {
      required:true
    }
 },

 messages:{
    title : {
      required:'Please Enter Menu Name'
    },
 },

 errorPlacement: function(error, element){
    if(element.attr("name") == "category[]") {
      error.appendTo( element.parent(".form-group") );
    } else {
      error.insertAfter(element);
    }
 }

})

});
  </script>
@endsection