@extends('back.layout.master')



@section('breadcrum')

<section class="content-header">

  <div class="container-fluid">

    <div class="row mb-2">

      <div class="col-sm-6">

        <h1>Brand Management</h1>

      </div>

      <div class="col-sm-6">

        <ol class="breadcrumb float-sm-right">

          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>

          <li class="breadcrumb-item"><a href="{{route('brand-list')}}">Brand Management</a></li>

          <li class="breadcrumb-item active">Edit</li>

        </ol>

      </div>

    </div>

  </div>

  <!-- /.container-fluid -->

</section>

@endsection







@section('content')

<section class="content">

  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{route('brand-list')}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>

  <br>





{{-- @if($errors->any())

<div class="alert alert-danger">

  <ul>

      @foreach ($errors->all() as $error)

        <li>{{ $error }}</li>

      @endforeach

  </ul>

</div><br />

@endif --}}









  <form method="POST" name="brandadd" id="brandadd" enctype="multipart/form-data" action="{{route('brand-update',$currentRecord->id)}}?page={{$page}}">

  @csrf

  @method('PUT')

  <div class="row">

    <div class="col-md-12">

      <div class="card card-primary"> {{--

        <div class="card-header">

          <h3 class="card-title">General</h3>

          <div class="card-tools">

            <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>

          </div>

        </div>

        --}}

        <div class="card-body">          

          <div class="form-group">

            <label for="inputName">Brand Name</label>

            <input type="text" id="name" name="name" class="form-control" value="{{$currentRecord->name}}">

          </div>

          

          

          

          

          

          <div class="row">

            <div class="col-md-6">

              <div class="form-group">

                <label for="customFile">Brand Image</label>

                <div class="custom-file">

                  <input type="file" class="image"  id="{{$currentRecord->id}}" name="image" >

                  <label class="image" for="customFile"></label>

                </div>

               

                <img src="{{asset('public/storage/brand/')}}/{{$currentRecord->image}}" style="max-width:100px; max-height:100px;"  />

               

              </div>

            

            </div>

              

           

          </div>

          

          

          <div class="form-group">

            <label for="inputName">Brand Link</label>

            <input type="text" id="blink" name="blink" class="form-control" value="{{$currentRecord->link}}">

          </div>



          <div class="row">

            

            <div class="col-md-6">

              <div class="form-group">

                <label for="inputStatus">Status</label>

                <select class="form-control custom-select"  id="status" name="status" >

                  <option value="1" @if($currentRecord->status == '1') selected="selected" @endif>Disable</option>

                  <option value="2" @if($currentRecord->status == '2') selected="selected" @endif>Enable</option>

                </select>

              </div>

            </div>

        

      

        </div>


 <div class="form-group">
            <label for="inputName">Meta Title</label>
            <input type="text" id="meta_title" name="meta_title" class="form-control" value="{{$currentRecord->meta_title}}">
          </div>
          <div class="form-group">
            <label for="inputDescription">Meta Description</label>
            <textarea  id="meta_description" name="meta_description"  class="form-control" rows="4">{{$currentRecord->meta_description}}</textarea>
          </div>
          <div class="form-group">
            <label for="inputDescription">Meta Keywords</label>
            <textarea  id="meta_keywords" name="meta_keywords"  class="form-control" rows="2">{{$currentRecord->meta_keywords}}</textarea>
          </div>

          </div>

        <!-- /.card-body -->

        <div class="form-group">

          <div class="col-12 text-center">

            <input type="submit" value="Save" name="product_submit" id="product_submit" class="btn btn-success ">

            <a href="{{url()->previous()}}" class="btn btn-secondary">Cancel</a> </div>

        </div>

      </div>

      <!-- /.card -->

    </div>

  </div>

</form>

  <p>&nbsp;</p>

</section>

@endsection



@section('style')

<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/date_picker_jq/jquery-ui.css') }}" rel="stylesheet">

<link href="{{asset('public/plugin/date_picker_jq/select2.min.css') }}" rel="stylesheet">



@endsection





@section('script')

<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>

<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>

<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>

<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>

<script src="{{asset('public/plugin/date_picker_jq/jquery-ui.js') }}"></script>



<script>

    $(document).ready(function() {





      $( "#product_date" ).datepicker({

        dateFormat: 'dd-mm-yy',

        /*minDate: 1,*/

        changeMonth: true,

        changeYear: true,

        yearRange: "-10:+10",

        onSelect: function(dateText, inst){

        //mYt("#cal_start_date_2").datepicker("option","minDate",mYt("#cal_start_date_1").datepicker("getDate"));

        }

      });





  $('.summernote').summernote({

    height: 200,

    popover: {

              image: [],

              link: [],

              air: []

            },

	callbacks: {

    onPaste: function (e) {

      var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('text/html');

	  if(bufferText)

	  {

      e.preventDefault();

      var div = $('<div />');

      div.append(bufferText);

      div.find('*').removeAttr('style');

      setTimeout(function () {

        document.execCommand('insertHtml', false, div.html());

      }, 10);

    }

	}

  }

  });







  $("#product_category").select2({

    tags: true,

    tokenSeparators: [',']

})



$('#product_category').show();





$('#brandadd').validate({

  rules:{    

    name : {

      required:true

    },

	image:{

	required:true

	},

	

	

 },



 messages:{

    name : {

      required:'Please Enter Brand Name'

    },

	image:

	:{

      required:'Please Select brand image'

    },

 },



 errorPlacement: function(error, element){

    if(element.attr("name") == "product_category[]") {

      error.appendTo( element.parent(".form-group") );

    } else {

      error.insertAfter(element);

    }

 }



})



});

  </script>

@endsection