 @extends('back.layout.master')

@section('breadcrum')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Edit Profile</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item">Edit Profile</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>
@endsection





@section('content')
<section class="content">
  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{route('admin.dashboard')}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>
  <br>
  @if($errors->any())
  <div class="alert alert-danger">
    <ul>
      @foreach ($errors->all() as $error)
      <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
  <br />
  @endif
  <form method="POST" name="upfledit" id="upfledit" enctype="multipart/form-data" action="{{route('profile-update')}}">
    @csrf
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary"> {{--
          <div class="card-header">
            <h3 class="card-title">General</h3>
            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
            </div>
          </div>
          --}}
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Login Id</label>
                  <input type="text" id="u_lgnid" name="u_lgnid" class="form-control" value="{{$userRec->email}}" readonly="readonly" disabled="disabled">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Name*</label>
                  <input type="text" id="u_name" name="u_name" class="form-control" value="{{$userRec->name}}">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Email*</label>
                  <input type="text" id="u_email" name="u_email" class="form-control" value="{{$userRec->contact_email}}">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Phone</label>
                  <input type="text" id="u_phone" name="u_phone" class="form-control" value="{{$userRec->phone}}">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="customFile">Profile Image</label>
                  <div class="custom-file">
                    <input type="file" class="blog_image"  id="u_profile" name="u_profile" >
                    <label class="blog_image" for="customFile"></label>
                  </div>
                  @if($userRec->avatar != '') <img src="{{asset('public/storage/profile/'.$userRec->avatar )}}" style="max-width:100px; max-height:100px;"  /> @else <img src="{{asset('public/front/uploads/img/emptyprofile.jpg')}}" style="max-width:100px; max-height:100px;"  /> @endif </div>
                @error('blog_image')
                <label class="error">{{ $message }}</label>
                @enderror </div>
            </div>
          </div>
          <!-- /.card-body -->
          <div class="form-group">
            <div class="col-12 text-center">
              <input type="submit" value="Save" name="category_submit" id="category_submit" class="btn btn-success ">
              <a href="{{route('admin.dashboard')}}"  class="btn btn-secondary">Cancel</a> </div>
          </div>
        </div>
        <!-- /.card -->
      </div>
    </div>
  </form>
  <p>&nbsp;</p>
</section>
@endsection

@section('style')
<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">
@endsection


@section('script')
<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>
<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>
<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>
<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>
<script>
    $(document).ready(function() {

$('#upfledit').validate({
  rules:{
    u_name : {
      required:true
    },
	u_email : {
      required:true
    },
 },

 messages:{
  /*  u_name : {
      required:'Please enter name'
    }*/
 },

 errorPlacement: function(error, element){    
     error.insertAfter(element);   
 }

})

});
  </script>
@endsection