 @extends('back.layout.master')

@section('breadcrum')
<section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>Change Password</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
          <li class="breadcrumb-item">Change Password</li>
        </ol>
      </div>
    </div>
  </div>
  <!-- /.container-fluid -->
</section>
@endsection





@section('content')
<section class="content">
  <div style="float:none; width:100%; text-align:right; position absolute; right:0;" class="btn-block"> <a href="{{route('admin.dashboard')}}" style="width:100px;" class="btn  bg-gradient-primary btn-sm"> Back </a> </div>
  <br>
  @if($errors->any())
  <div class="alert alert-danger">
    <ul>
      @foreach ($errors->all() as $error)
      <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
  <br />
  @endif
  <form method="POST" name="upfledit" id="upfledit" enctype="multipart/form-data" action="{{route('update-password')}}">
    @csrf
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary"> {{--
          <div class="card-header">
            <h3 class="card-title">General</h3>
            <div class="card-tools">
              <button type="button" class="btn btn-tool" data-card-widget="collapse" data-toggle="tooltip" title="Collapse"> <i class="fas fa-minus"></i></button>
            </div>
          </div>
          --}}
          <div class="card-body">
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Login Id</label>
                  <input type="text" id="u_lgnid" name="u_lgnid" class="form-control" value="{{$userRec->email}}" readonly="readonly" disabled="disabled">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Old Password*</label>
                  <input type="password" id="current_password" name="current_password" class="form-control" value="">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">New Password*</label>
                  <input type="password" id="new_password" name="new_password" class="form-control" value="">
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label for="inputName">Confirm Password</label>
                  <input type="password" id="new_confirm_password" name="new_confirm_password" class="form-control" value="">
                </div>
              </div>
              
            </div>
          </div>
          <!-- /.card-body -->
          <div class="form-group">
            <div class="col-12 text-center">
              <input type="submit" value="Save" name="category_submit" id="category_submit" class="btn btn-success ">
              <a href="{{route('admin.dashboard')}}"  class="btn btn-secondary">Cancel</a> </div>
          </div>
        </div>
        <!-- /.card -->
      </div>
    </div>
  </form>
  <p>&nbsp;</p>
</section>
@endsection

@section('style')
<link href="{{asset('public/plugin/summernote/summernote.css') }}" rel="stylesheet">
<link href="{{asset('public/plugin/select2/select2.min.css') }}" rel="stylesheet">
@endsection


@section('script')
<script src="{{asset('public/plugin/summernote/summernote.js') }}"></script>
<script src="{{asset('public/plugin/select2/select2.min.js') }}"></script>
<script src="{{asset('public/plugin/validate/jquery.validate.js') }}"></script>
<script src="{{asset('public/plugin/validate/additional-methods.js') }}"></script>
<script>
    $(document).ready(function() {

$('#upfledit').validate({
  rules:{
    current_password : {
      required:true
    },
	new_password : {
      required:true,
	  minlength : 6
    },
	new_confirm_password : {
      required:true,
	  minlength : 6,
	  equalTo : '#new_confirm_password'
    },
 },

 messages:{
  /*  u_name : {
      required:'Please enter name'
    }*/
 },

 errorPlacement: function(error, element){    
     error.insertAfter(element);   
 }

})

});
  </script>
@endsection