<?php
namespace App\Services;
use Illuminate\Support\Facades\DB;
use Storage;

class Slug
{
    /**
     * @param $title
     * @param int $id
     * @return string
     * @throws \Exception
     */
    public function createSlug($table, $col, $title, $id = 0)
    {
        // Normalize the title
        $slug = str_slug($title);
        // Get any that could possibly be related.
        // This cuts the queries down by doing it once.
        $allSlugs = $this->getRelatedSlugs($table, $col, $slug, $id);
        // If we haven't used it before then we are all good.
        if (! $allSlugs->contains($col, $slug)){
            return $slug;
        }
        // Just append numbers like a savage until we find not used.
        for ($i = 1; $i <= 10; $i++) {
            $newSlug = $slug.'-'.$i;
            if (! $allSlugs->contains($col, $newSlug)) {
                return $newSlug;
            }
        }
        throw new \Exception('Can not create a unique slug');
    }
    protected function getRelatedSlugs($table, $col, $slug, $id = 0)
    {
        return DB::table($table)->select($col)->where($col, 'like', $slug.'%')
            ->where('id', '<>', $id)
            ->get();
    }
}



// On create
//$post->slug = $slug->createSlug($table, $col, $request->title);

// On update
// if ($post->slug != $request->slug) {
//     $post->slug = $slug->createSlug($table, $col, $request->slug, $id);
//    }

