<?php

namespace App\Http\Controllers\Auth;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Auth\Events\Registered;
use DB;


class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    

    //  public function showLinkRequestForm(){
    //     return view('auth.passwords.m-email');
    // }

    // public function showResetForm(Request $request, $token = null){
    //     return view('auth.passwords.m-reset')->with(
    //         ['token' => $token, 'email' => $request->email]
    //     );
    // }

    public function showRegistrationForm() {

	$common = DB::table('settings')->where('id','1')->first();
	           $slider=$common->slidercontent;
	           $cn=explode(',',$slider);
		       $common->content1=$cn[0];
			   $common->content2=$cn[1];
		       $common->content3=$cn[2];


        return view('front.register', compact('common'));
    }

    public function register(Request $request)
    {
        $this->validator($request->all())->validate();

        event(new Registered($user = $this->create($request->all())));
        
        if(isset($user->id) && $user->id > 0 )
        {
            // $userRole = new Role;
             $roleData = array("user_id"=>$user->id,"role_id"=>'3');
            // $userRole->create($roleData);
            DB::table('role_user')->insert($roleData);

        }
        return $this->registered($request, $user)
                        ?: redirect($this->redirectPath());
    }

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }
}
