<?php

namespace App\Http\Controllers\Auth;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Auth;

use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Session;
use DB;

class LoginController extends Controller

{

    /*

    |--------------------------------------------------------------------------

    | Login Controller

    |--------------------------------------------------------------------------

    |

    | This controller handles authenticating users for the application and

    | redirecting them to your home screen. The controller uses a trait

    | to conveniently provide its functionality to your applications.

    |

    */



    use AuthenticatesUsers;



    public function showLoginForm() {

$common = DB::table('settings')->where('id','1')->first();
           $slider=$common->slidercontent;
           $cn=explode(',',$slider);
	       $common->content1=$cn[0];
		   $common->content2=$cn[1];
	       $common->content3=$cn[2];


        return view('front.login', compact('common'));

     }



     protected function sendLoginResponse(Request $request)

    {

        $request->session()->regenerate();



        $this->clearLoginAttempts($request);



        

       if($this->guard()->user()->status==1)

       {

            return $this->authenticated($request, $this->guard()->user())?: redirect()->intended($this->redirectPath());

       }else if($this->guard()->user()->status==0){

        $this->guard()->logout();

        $request->session()->invalidate();

        return $this->loggedOut($request) ?: redirect('/login')->with('status','Your request to access this Portal is still pending. Please try after approval');;



       }else{



        $this->guard()->logout();

        $request->session()->invalidate();

        return $this->loggedOut($request) ?: redirect('/login')->with('status','Access Denied');;





       }

        

    }





    /**

     * Where to redirect users after login.

     *

     * @var string

     */

    //protected $redirectTo = '/home';

    public function redirectTo(){

        

        // User role

        $newrole=array();

       

        foreach (Auth::user()->roles()->get() as $role)

        {

           $newrole[]  = $role->name;

        }

        if(count($newrole) > 1)

        {

            return '/common/dashboard';

            exit();

        }

        if(in_array('Admin', $newrole))

        {

            session(['role' => 'admin']);

            return '/administrator/dashboard';

            exit();

        }

        if(in_array('Sub Admin', $newrole))

        {

            session(['role' => 'subadmin']);



            return '/administrator/dashboard';

            exit();

        }

       

        if(in_array('User', $newrole))

        {

            return '/client/dashboard';

            exit();

        }



        return '/login'; 

        exit();



        

    }

    /**

     * Create a new controller instance.

     *

     * @return void

     */

	 

	 public function logout(Request $request)

    {

		Auth::logout();
        $this->guard()->logout();



        $request->session()->flush();



        $request->session()->regenerate();



        return redirect('/home');

    }

	 

    public function __construct()

    {

        $this->middleware('guest')->except('logout');

    }

	

	

}

