<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;

use Mail;

class UserActivateController extends Controller
{


    public function __construct()
    {
        
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
			//   $common = DB::table('onew_common')->where('id','1')->first();

        $recordToShow = 20;
        // $users = DB::table('users')->with('roles')->join('roles', 'roles.user_id', '=', 'users.id')->where('roles.name', 'admin')->get();

        $userList = DB::table('users')->orderBy('id','desc')->where('id','>','1')->orderBy('created_at','desc')->paginate($recordToShow);
        foreach($userList as $user){
            $role= DB::table('role_user')->where('user_id',$user->id)->get();
            $rolelist = DB::table('roles')->where('id',$role[0]->role_id)->get();
            $user->rolename=$rolelist[0]->name;

        }
        //$userList=$user;
        return view('back.useractivate.useractivate',compact('userList','recordToShow'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //$newscategory = DB::table('trainer')->where('id','>','0')->orderBy('name','asc')->get();
        // return view('back.news.news-add')->withNewscategory($newscategory);
        // return view('back.news.news-add',compact('newscategory','anothervar'));
        return view('back.tag.tag-add');
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;


        $request->validate([
            'tag_name' => 'required',
            'description' => 'required'
            ]);


        
        $n_tagname = $request->tag_name;
        $n_desc = $request->description;       
        $tag_status = $request->tag_status;

           
        $insrec = DB::table('tag')->insertGetId(
            [
                'tag_name' => $n_tagname,
                'description' => $n_desc,
                'status' => $tag_status,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId
                  ]);
            
            if($insrec > 0)
            {
                return redirect()->route('tag-list')->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('tag-list')->with('error', 'Error occurred.Please Try Again Later.');
            }
       

        

        
        


        



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $getRow = DB::table('tag')->where('id',$id)->first();
        return view('back.tag.tag-view',['currentRecord'=>$getRow]);
                   
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('tag')->where('id',$id)->first();
        return view('back.tag.tag-edit',['currentRecord'=>$getRow,'page'=>$pageNumber]);
            }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //echo $id;die();
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('tag')->where('id',$id)->first();
        
        

        $request->validate([
            'tag_name' => 'required',
            'description' => 'required'
        ]);


        

        $n_tagname = $request->tag_name;
        $n_desc = $request->description;
        $tag_status = $request->tag_status;

        $updaterec = DB::table('tag')->where('id', $id)
            ->update(
            [
                'tag_name' => $n_tagname,
                'description' => $n_desc,
                'status' => $tag_status,
                'updated_at' => $dateTime,
                'updated_by' => $userId,
           ]);
            
            $pageNumber = $request->input('page','1');

            if($updaterec > 0)
            {
                return redirect()->route('tag-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('tag-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');
            }
        

    }


    public function updateStatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update users set status = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
                if($request->chtyp == 1){
            $details = DB::table('users')->where('id',$request->chid)->get()->toArray();//echo $details['password'];die();
            Mail::send([], $details, function($message) use($details) {
                 $message->to($details[0]->email , $details[0]->name)->subject
                    ('Thanks for Registration - CyberBahn');
                $message->setBody('Dear '.$details[0]->name.',<br> <b style="text-align-center">You have been given access to CyberBahn 
.<br>Now you can login using your credentials</b><br><a href="'.url("login").'">Login using this link</a><br><br><br>Thanks,<br><img class="mt-5 mb-20" alt="CyberBahn" src="'.url("public/front/images/emailfooter.png").'">', 'text/html'); 
                 $message->from("p.diana@cyberbahnit.com","CyberBahn");
              });

        
            if(Mail::failures() && count(Mail::failures()) > 0 ) {
                $msg = "Error";
            }else
            {
                $msg = "Success";
            }

                }else if($request->chtyp == 0){
            $details = DB::table('users')->where('id',$request->chid)->get()->toArray();
            Mail::send([], $details, function($message) use($details) {
                 $message->to($details[0]->email , 'CyberBahn')->subject
                    ('User Deactivation - CyberBahn');
                $message->setBody('Dear '.$details[0]->name.',<br> <b style="text-align-center">Your account has been deactivated.Please contact administrator.<br>', 'text/html'); 
                 $message->from("p.diana@cyberbahnit.com","CyberBahn");
              });

        
            if(Mail::failures() && count(Mail::failures()) > 0 ) {
                $msg = "Error";
            }else
            {
                $msg = "Success";
            }

                }
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if($id > 0)
        {
            $getRow = DB::table('users')->where('id',$id)->first();

                     

            $delete = DB::table('users')->where('id',$id)->delete();
            if($delete > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }
        $results=array("msg"=>$msg,"status"=>$sts);
        return response()->json($results);
 
    }


    
}
